/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.utils;

import com.magmaguy.elitemobs.config.CustomModelsConfig;
import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.versionnotifier.VersionChecker;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.EquippableComponent;

public class CustomModelAdder {
    public static ItemStack addCustomModel(ItemStack itemStack, String customModelData) {
        if (itemStack == null || itemStack.getItemMeta() == null || customModelData == null || customModelData.isEmpty()) {
            return itemStack;
        }
        itemStack.setItemMeta(CustomModelAdder.addCustomModel(itemStack.getItemMeta(), customModelData));
        return itemStack;
    }

    public static ItemMeta addCustomModel(ItemMeta itemMeta, String customModelData) {
        if (!CustomModelsConfig.useModels) {
            return itemMeta;
        }
        if (!DefaultConfig.useResourcePackModels()) {
            return itemMeta;
        }
        if (VersionChecker.serverVersionOlderThan(21, 4) || itemMeta == null) {
            return itemMeta;
        }
        itemMeta.setItemModel(NamespacedKey.fromString((String)customModelData));
        return itemMeta;
    }

    public static ItemStack addEquippableModel(ItemStack itemStack, String equipmentModelId) {
        if (itemStack == null || itemStack.getItemMeta() == null) {
            return itemStack;
        }
        if (!CustomModelsConfig.useModels) {
            return itemStack;
        }
        if (!DefaultConfig.useResourcePackModels()) {
            return itemStack;
        }
        if (VersionChecker.serverVersionOlderThan(21, 4)) {
            return itemStack;
        }
        EquipmentSlot slot = CustomModelAdder.getArmorSlot(itemStack.getType());
        if (slot == null) {
            return itemStack;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        EquippableComponent equippable = itemMeta.getEquippable();
        equippable.setSlot(slot);
        if (slot != EquipmentSlot.HEAD && equipmentModelId != null && !equipmentModelId.isEmpty()) {
            equippable.setModel(NamespacedKey.fromString((String)equipmentModelId));
        }
        itemMeta.setEquippable(equippable);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Deprecated
    public static ItemMeta addEquippableModel(ItemMeta itemMeta, String equipmentModelId) {
        if (!CustomModelsConfig.useModels) {
            return itemMeta;
        }
        if (!DefaultConfig.useResourcePackModels()) {
            return itemMeta;
        }
        if (VersionChecker.serverVersionOlderThan(21, 4) || itemMeta == null) {
            return itemMeta;
        }
        EquippableComponent equippable = itemMeta.getEquippable();
        equippable.setModel(NamespacedKey.fromString((String)equipmentModelId));
        itemMeta.setEquippable(equippable);
        return itemMeta;
    }

    private static EquipmentSlot getArmorSlot(Material material) {
        String name = material.name();
        if (name.endsWith("_HELMET") || name.equals("CARVED_PUMPKIN") || name.endsWith("_HEAD") || name.endsWith("_SKULL")) {
            return EquipmentSlot.HEAD;
        }
        if (name.endsWith("_CHESTPLATE") || name.equals("ELYTRA")) {
            return EquipmentSlot.CHEST;
        }
        if (name.endsWith("_LEGGINGS")) {
            return EquipmentSlot.LEGS;
        }
        if (name.endsWith("_BOOTS")) {
            return EquipmentSlot.FEET;
        }
        return null;
    }
}

