/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.thirdparty.placeholderapi;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.economy.EconomyHandler;
import com.magmaguy.elitemobs.playerdata.ElitePlayerInventory;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.magmacore.util.Round;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Placeholders
extends PlaceholderExpansion {
    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String getAuthor() {
        return MetadataHandler.PLUGIN.getDescription().getAuthors().toString();
    }

    public String getIdentifier() {
        return "elitemobs";
    }

    public String getVersion() {
        return MetadataHandler.PLUGIN.getDescription().getVersion();
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        if (player == null) {
            return "Only online players!";
        }
        if (!PlayerData.isInMemory(player.getUniqueId()) || PlayerData.getPlayerData(player.getUniqueId()) == null) {
            return "Uninitialized player data!";
        }
        switch (identifier) {
            case "player_combat_tier": {
                return "" + ElitePlayerInventory.playerInventories.get(player.getUniqueId()).getFullPlayerTier(false);
            }
            case "player_money": {
                return "" + Round.twoDecimalPlaces(EconomyHandler.checkCurrency(player.getUniqueId()));
            }
            case "player_top_tier": {
                double highestThreat = 0.0;
                for (Player iteratedPlayer : Bukkit.getOnlinePlayers()) {
                    double currentTier = ElitePlayerInventory.playerInventories.get(iteratedPlayer.getUniqueId()).getFullPlayerTier(true);
                    if (!(currentTier > highestThreat)) continue;
                    highestThreat = currentTier;
                }
                return "" + highestThreat;
            }
            case "player_kills": {
                return "" + PlayerData.getKills(player.getUniqueId());
            }
            case "player_deaths": {
                return "" + PlayerData.getDeaths(player.getUniqueId());
            }
            case "player_active_guild_rank_numerical": 
            case "player_maximum_guild_rank_numerical": 
            case "player_active_guild_rank_name": 
            case "player_maximum_guild_rank_name": 
            case "player_prestige_guild_rank_numerical": 
            case "player_top_guild_rank": 
            case "player_shortened_guild_rank": {
                return "N/A";
            }
        }
        return null;
    }
}

