/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.testing;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.testing.SkillTestResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;

public class TestReport {
    private final UUID playerUUID;
    private final long startTime;
    private long endTime;
    private final List<SkillTestResult> results = new ArrayList<SkillTestResult>();
    private final Map<SkillType, List<SkillTestResult>> resultsByType = new HashMap<SkillType, List<SkillTestResult>>();
    private int totalTests = 0;
    private int passedTests = 0;
    private int failedTests = 0;
    private int warningTests = 0;

    public TestReport(UUID playerUUID) {
        this.playerUUID = playerUUID;
        this.startTime = System.currentTimeMillis();
    }

    public void addResult(SkillTestResult result) {
        this.results.add(result);
        this.resultsByType.computeIfAbsent(result.getSkillType(), k -> new ArrayList()).add(result);
        ++this.totalTests;
        if (result.isPassed()) {
            ++this.passedTests;
        } else if (result.getIssues().stream().anyMatch(s -> s.contains("mismatch"))) {
            ++this.failedTests;
        } else {
            ++this.warningTests;
        }
    }

    public List<String> generateSummary() {
        this.endTime = System.currentTimeMillis();
        long duration = (this.endTime - this.startTime) / 1000L;
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("");
        lines.add("&6&l========== SKILL SYSTEM TEST REPORT ==========");
        lines.add("");
        lines.add(String.format("&7Duration: &f%d seconds", duration));
        lines.add(String.format("&7Total Tests: &f%d", this.totalTests));
        lines.add(String.format("&aPassed: &f%d &7| &cFailed: &f%d &7| &eWarnings: &f%d", this.passedTests, this.failedTests, this.warningTests));
        lines.add("");
        for (SkillType type : SkillType.values()) {
            List<SkillTestResult> typeResults = this.resultsByType.get((Object)type);
            if (typeResults == null || typeResults.isEmpty()) continue;
            long passed = typeResults.stream().filter(SkillTestResult::isPassed).count();
            long failed = (long)typeResults.size() - passed;
            String statusColor = failed == 0L ? "&a" : "&c";
            lines.add(String.format("&e%s: %s%d/%d passed", type.getDisplayName(), statusColor, passed, typeResults.size()));
            for (SkillTestResult result : typeResults) {
                if (result.isPassed()) continue;
                lines.add("  &c- " + result.getSkillName() + " (Lv." + result.getTestLevel() + ")");
                for (String issue : result.getIssues()) {
                    lines.add("    &7" + issue);
                }
            }
        }
        lines.add("");
        if (this.failedTests == 0) {
            lines.add("&a&lALL TESTS PASSED!");
        } else {
            lines.add(String.format("&c&l%d TEST(S) FAILED - Review issues above", this.failedTests));
        }
        lines.add("&6&l================================================");
        return lines;
    }

    public List<String> generateDetailedReport() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("&6&l========== DETAILED TEST REPORT ==========");
        lines.add("");
        for (SkillType type : SkillType.values()) {
            List<SkillTestResult> typeResults = this.resultsByType.get((Object)type);
            if (typeResults == null || typeResults.isEmpty()) continue;
            lines.add("&e&l" + type.getDisplayName());
            lines.add("&7" + "-".repeat(40));
            for (SkillTestResult result : typeResults) {
                lines.add(result.getSummary());
                for (String log : result.getLogs()) {
                    lines.add("  &7" + log);
                }
            }
            lines.add("");
        }
        return lines;
    }

    public String exportToText() {
        StringBuilder sb = new StringBuilder();
        sb.append("ELITEMOBS SKILL SYSTEM TEST REPORT\n");
        sb.append("==================================\n\n");
        sb.append("Generated: ").append(new Date()).append("\n");
        sb.append("Duration: ").append((this.endTime - this.startTime) / 1000L).append(" seconds\n\n");
        sb.append("SUMMARY\n");
        sb.append("-------\n");
        sb.append("Total: ").append(this.totalTests).append("\n");
        sb.append("Passed: ").append(this.passedTests).append("\n");
        sb.append("Failed: ").append(this.failedTests).append("\n");
        sb.append("Warnings: ").append(this.warningTests).append("\n\n");
        sb.append("DETAILED RESULTS\n");
        sb.append("----------------\n\n");
        for (SkillType type : SkillType.values()) {
            List<SkillTestResult> typeResults = this.resultsByType.get((Object)type);
            if (typeResults == null || typeResults.isEmpty()) continue;
            sb.append(type.getDisplayName().toUpperCase()).append("\n");
            sb.append("-".repeat(type.getDisplayName().length())).append("\n");
            for (SkillTestResult result : typeResults) {
                sb.append(String.format("  [%s] %s (Lv.%d)\n", result.isPassed() ? "PASS" : "FAIL", result.getSkillName(), result.getTestLevel()));
                if (result.getExpectedProcRate() > 0.0) {
                    sb.append(String.format("    Proc Rate: %.1f%% (expected %.1f%%)\n", result.getActualProcRate() * 100.0, result.getExpectedProcRate() * 100.0));
                }
                if (result.getExpectedDamageMultiplier() != 1.0) {
                    sb.append(String.format("    Damage Mult: %.2fx (expected %.2fx)\n", result.getActualDamageMultiplier(), result.getExpectedDamageMultiplier()));
                }
                sb.append(String.format("    Hits: %d | Total Damage: %.1f | Skill Bonus: %.1f\n", result.getTotalHits(), result.getTotalDamageDealt(), result.getSkillBonusDamage()));
                if (!result.isPassed()) {
                    for (String issue : result.getIssues()) {
                        sb.append("    ! ").append(issue).append("\n");
                    }
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Generated
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public long getEndTime() {
        return this.endTime;
    }

    @Generated
    public List<SkillTestResult> getResults() {
        return this.results;
    }

    @Generated
    public Map<SkillType, List<SkillTestResult>> getResultsByType() {
        return this.resultsByType;
    }

    @Generated
    public int getTotalTests() {
        return this.totalTests;
    }

    @Generated
    public int getPassedTests() {
        return this.passedTests;
    }

    @Generated
    public int getFailedTests() {
        return this.failedTests;
    }

    @Generated
    public int getWarningTests() {
        return this.warningTests;
    }
}

