/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.testing;

import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.api.utils.EliteItemManager;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfig;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfigFields;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.items.EliteItemLore;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.RegionalBossEntity;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public class CombatSimulator {
    private final Player player;
    private final Map<String, CustomBossEntity> dummies = new HashMap<String, CustomBossEntity>();
    private final Map<String, Location> dummyLocations = new HashMap<String, Location>();
    private LivingEntity currentDummyEntity = null;
    private static final String DUMMY_CONFIG = "training_dummy.yml";
    private static final String COMBAT_DUMMY_CONFIG = "training_dummy_combat.yml";
    private static final double SPAWN_DISTANCE = 5.0;
    private ItemStack savedHelmet;
    private ItemStack savedChestplate;
    private ItemStack savedLeggings;
    private ItemStack savedBoots;
    private double lastProjectileDamage = 0.0;
    private String lastProjectileTarget = null;
    private double lastTargetHealthBefore = 0.0;

    public CombatSimulator(Player player) {
        this.player = player;
    }

    public boolean spawnSingleDummy(SkillBonus skill) {
        this.killCurrentDummy();
        this.removeAllDummies();
        this.resetProjectileTracking();
        Vector direction = this.player.getLocation().getDirection();
        direction.setY(0).normalize();
        Location spawnLoc = this.player.getLocation().add(direction.multiply(5));
        int highestY = spawnLoc.getWorld().getHighestBlockYAt(spawnLoc);
        spawnLoc.setY((double)(highestY + 1));
        spawnLoc.setDirection(this.player.getLocation().toVector().subtract(spawnLoc.toVector()).normalize());
        return this.spawnDummyForSkill(skill, spawnLoc);
    }

    private void killCurrentDummy() {
        if (this.currentDummyEntity != null) {
            if (this.currentDummyEntity.isValid() && !this.currentDummyEntity.isDead()) {
                this.currentDummyEntity.setHealth(0.0);
                this.currentDummyEntity.remove();
            }
            this.currentDummyEntity = null;
        }
    }

    private boolean spawnDummyForSkill(SkillBonus skill, Location location) {
        String configToUse = skill.getSkillType() == SkillType.ARMOR ? COMBAT_DUMMY_CONFIG : DUMMY_CONFIG;
        CustomBossesConfigFields config = CustomBossesConfig.getCustomBoss(configToUse);
        if (config == null) {
            config = CustomBossesConfig.getCustomBoss(DUMMY_CONFIG);
            configToUse = DUMMY_CONFIG;
        }
        if (config == null) {
            return false;
        }
        RegionalBossEntity dummy = RegionalBossEntity.createTemporaryRegionalBossEntity(configToUse, location);
        if (dummy == null) {
            return false;
        }
        ((CustomBossEntity)dummy).spawn(true);
        if (dummy.getLivingEntity() != null) {
            LivingEntity entity = dummy.getLivingEntity();
            entity.setMaximumNoDamageTicks(0);
            entity.setNoDamageTicks(0);
            String skillName = skill.getBonusName();
            String typeName = skill.getSkillType().getDisplayName();
            String displayName = "\u00a7e" + typeName + " \u00a77- \u00a7f" + skillName + " \u00a78[Pending]";
            entity.setCustomName(displayName);
            entity.setCustomNameVisible(true);
            entity.setGlowing(true);
            this.currentDummyEntity = entity;
            this.dummies.put(skill.getSkillId(), dummy);
            this.dummyLocations.put(skill.getSkillId(), location);
            return true;
        }
        return false;
    }

    public void markDummyAsTesting(String skillId, String skillName, SkillType skillType) {
        CustomBossEntity dummy = this.dummies.get(skillId);
        if (dummy != null && dummy.isValid() && dummy.getLivingEntity() != null) {
            String displayName = "\u00a76\u2694 " + skillType.getDisplayName() + " \u00a77- \u00a7e" + skillName + " \u00a76[TESTING]";
            dummy.getLivingEntity().setCustomName(displayName);
        }
    }

    public void markDummyAsPassed(String skillId, String skillName, SkillType skillType, double procRate) {
        CustomBossEntity dummy = this.dummies.get(skillId);
        if (dummy != null && dummy.isValid() && dummy.getLivingEntity() != null) {
            String displayName = String.format("\u00a7a\u2713 %s \u00a77- \u00a7f%s \u00a7a[%.0f%%]", skillType.getDisplayName(), skillName, procRate * 100.0);
            dummy.getLivingEntity().setCustomName(displayName);
            dummy.getLivingEntity().setGlowing(false);
        }
    }

    public void markDummyAsFailed(String skillId, String skillName, SkillType skillType, String reason) {
        CustomBossEntity dummy = this.dummies.get(skillId);
        if (dummy != null && dummy.isValid() && dummy.getLivingEntity() != null) {
            String displayName = "\u00a7c\u2717 " + skillType.getDisplayName() + " \u00a77- \u00a7f" + skillName + " \u00a7c[FAILED]";
            dummy.getLivingEntity().setCustomName(displayName);
        }
    }

    public CustomBossEntity getDummy(String skillId) {
        return this.dummies.get(skillId);
    }

    public LivingEntity getDummyEntity(String skillId) {
        CustomBossEntity dummy = this.dummies.get(skillId);
        if (dummy != null && dummy.isValid()) {
            return dummy.getLivingEntity();
        }
        return null;
    }

    public boolean hasDummy(String skillId) {
        LivingEntity entity = this.getDummyEntity(skillId);
        return entity != null && entity.isValid() && !entity.isDead();
    }

    public void healDummy(String skillId) {
        CustomBossEntity dummy = this.dummies.get(skillId);
        if (dummy != null && dummy.isValid() && dummy.getLivingEntity() != null) {
            dummy.fullHeal();
        }
    }

    public boolean respawnIfDead(String skillId, SkillBonus skill) {
        CustomBossEntity dummy = this.dummies.get(skillId);
        if (dummy == null || !dummy.isValid() || dummy.getLivingEntity() == null || dummy.getLivingEntity().isDead()) {
            Location spawnLoc = this.dummyLocations.get(skillId);
            if (spawnLoc == null) {
                spawnLoc = this.player.getLocation().add(5.0, 0.0, 0.0);
            }
            this.dummies.remove(skillId);
            if (skillId.equals(this.lastProjectileTarget)) {
                this.lastProjectileTarget = null;
                this.lastTargetHealthBefore = 0.0;
            }
            return this.spawnDummyForSkill(skill, spawnLoc);
        }
        return true;
    }

    public void removeDummy(String skillId) {
        CustomBossEntity dummy = this.dummies.remove(skillId);
        if (dummy != null && dummy.isValid() && dummy.getLivingEntity() != null) {
            LivingEntity entity = dummy.getLivingEntity();
            entity.setHealth(0.0);
            entity.remove();
            if (entity == this.currentDummyEntity) {
                this.currentDummyEntity = null;
            }
        }
        this.dummyLocations.remove(skillId);
    }

    public void removeAllDummies() {
        for (CustomBossEntity dummy : this.dummies.values()) {
            if (dummy == null || !dummy.isValid() || dummy.getLivingEntity() == null) continue;
            LivingEntity entity = dummy.getLivingEntity();
            entity.setHealth(0.0);
            entity.remove();
        }
        this.dummies.clear();
        this.dummyLocations.clear();
        this.killCurrentDummy();
    }

    public void equipWeapon(SkillType skillType) {
        ItemStack weapon;
        switch (skillType) {
            default: {
                throw new MatchException(null, null);
            }
            case SWORDS: {
                ItemStack itemStack = new ItemStack(Material.NETHERITE_SWORD);
                break;
            }
            case AXES: {
                ItemStack itemStack = new ItemStack(Material.NETHERITE_AXE);
                break;
            }
            case BOWS: {
                ItemStack itemStack = new ItemStack(Material.BOW);
                break;
            }
            case CROSSBOWS: {
                ItemStack itemStack = new ItemStack(Material.CROSSBOW);
                break;
            }
            case TRIDENTS: {
                ItemStack itemStack = new ItemStack(Material.TRIDENT);
                break;
            }
            case HOES: {
                ItemStack itemStack = new ItemStack(Material.NETHERITE_HOE);
                break;
            }
            case ARMOR: {
                ItemStack itemStack = weapon = null;
            }
        }
        if (weapon != null) {
            this.player.getInventory().setItemInMainHand(weapon);
        }
    }

    public void equipArmorSet(int level) {
        ItemStack helmet = this.createEliteArmor(Material.IRON_HELMET, level);
        ItemStack chestplate = this.createEliteArmor(Material.IRON_CHESTPLATE, level);
        ItemStack leggings = this.createEliteArmor(Material.IRON_LEGGINGS, level);
        ItemStack boots = this.createEliteArmor(Material.IRON_BOOTS, level);
        this.player.getInventory().setHelmet(helmet);
        this.player.getInventory().setChestplate(chestplate);
        this.player.getInventory().setLeggings(leggings);
        this.player.getInventory().setBoots(boots);
    }

    private ItemStack createEliteArmor(Material material, int level) {
        ItemStack armor = new ItemStack(material);
        ItemMeta meta = armor.getItemMeta();
        meta.addEnchant(Enchantment.UNBREAKING, 5, true);
        armor.setItemMeta(meta);
        EliteItemManager.setEliteLevel(armor, level);
        new EliteItemLore(armor, false);
        return armor;
    }

    public void savePlayerArmor() {
        this.savedHelmet = this.player.getInventory().getHelmet();
        this.savedChestplate = this.player.getInventory().getChestplate();
        this.savedLeggings = this.player.getInventory().getLeggings();
        this.savedBoots = this.player.getInventory().getBoots();
    }

    public void restorePlayerArmor() {
        this.player.getInventory().setHelmet(this.savedHelmet);
        this.player.getInventory().setChestplate(this.savedChestplate);
        this.player.getInventory().setLeggings(this.savedLeggings);
        this.player.getInventory().setBoots(this.savedBoots);
    }

    public double simulateMeleeAttack(String skillId) {
        LivingEntity target = this.getDummyEntity(skillId);
        if (target == null || !target.isValid()) {
            return -1.0;
        }
        target.setNoDamageTicks(0);
        double healthBefore = target.getHealth();
        this.player.attack((Entity)target);
        double healthAfter = target.getHealth();
        return Math.max(0.0, healthBefore - healthAfter);
    }

    public void resetProjectileTracking() {
        this.lastProjectileDamage = 0.0;
        this.lastProjectileTarget = null;
        this.lastTargetHealthBefore = 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double simulateRangedAttack(String skillId) {
        LivingEntity target = this.getDummyEntity(skillId);
        if (target == null || !target.isValid()) {
            return -1.0;
        }
        target.setNoDamageTicks(0);
        double healthBefore = target.getHealth();
        EliteEntity eliteEntity = EntityTracker.getEliteMobEntity((Entity)target);
        if (eliteEntity == null || !eliteEntity.isValid()) {
            return -1.0;
        }
        double baseDamage = 8.0;
        EliteMobDamagedByPlayerEvent event = new EliteMobDamagedByPlayerEvent(eliteEntity, this.player, baseDamage, true);
        event.applySkillBonuses();
        double finalDamage = event.getDamage();
        EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = true;
        try {
            target.damage(finalDamage, (Entity)this.player);
        }
        finally {
            EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = false;
        }
        double healthAfter = target.getHealth();
        return Math.max(0.0, healthBefore - healthAfter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double simulateTridentAttack(String skillId) {
        LivingEntity target = this.getDummyEntity(skillId);
        if (target == null || !target.isValid()) {
            return -1.0;
        }
        target.setNoDamageTicks(0);
        double healthBefore = target.getHealth();
        EliteEntity eliteEntity = EntityTracker.getEliteMobEntity((Entity)target);
        if (eliteEntity == null || !eliteEntity.isValid()) {
            return -1.0;
        }
        double baseDamage = 8.0;
        EliteMobDamagedByPlayerEvent event = new EliteMobDamagedByPlayerEvent(eliteEntity, this.player, baseDamage, true);
        event.applySkillBonuses();
        double finalDamage = event.getDamage();
        EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = true;
        try {
            target.damage(finalDamage, (Entity)this.player);
        }
        finally {
            EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = false;
        }
        double healthAfter = target.getHealth();
        return Math.max(0.0, healthBefore - healthAfter);
    }

    public double simulateIncomingDamage(String skillId, double amount) {
        LivingEntity attacker = this.getDummyEntity(skillId);
        if (attacker == null) {
            return 0.0;
        }
        this.player.setNoDamageTicks(0);
        this.player.setHealth(this.player.getMaxHealth());
        this.player.setAbsorptionAmount(1000.0);
        double healthBefore = this.player.getHealth();
        double absorptionBefore = this.player.getAbsorptionAmount();
        double totalBefore = healthBefore + absorptionBefore;
        this.player.damage(amount, (Entity)attacker);
        double healthAfter = this.player.getHealth();
        double absorptionAfter = this.player.getAbsorptionAmount();
        double totalAfter = healthAfter + absorptionAfter;
        double actualDamage = totalBefore - totalAfter;
        this.player.setHealth(this.player.getMaxHealth());
        this.player.setAbsorptionAmount(0.0);
        return Math.max(0.0, actualDamage);
    }

    public int getDummyCount() {
        return this.dummies.size();
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }
}

