/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.tridents;

import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ProcSkill;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public class ImpaleSkill
extends SkillBonus
implements ProcSkill {
    public static final String SKILL_ID = "tridents_impale";
    private static final double BASE_PROC_CHANCE = 0.2;
    private static final double BASE_DAMAGE_MULTIPLIER = 1.5;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public ImpaleSkill() {
        super(SkillType.TRIDENTS, 10, "Impale", "Trident attacks have a chance to deal massive bonus damage that ignores armor.", SkillBonusType.PROC, 1, SKILL_ID);
    }

    @Override
    public double getProcChance(int skillLevel) {
        return Math.min(0.4, 0.2 + (double)skillLevel * 0.002);
    }

    @Override
    public void onProc(Player player, Object context) {
        if (!(context instanceof EliteMobDamagedByPlayerEvent)) {
            return;
        }
        EliteMobDamagedByPlayerEvent event = (EliteMobDamagedByPlayerEvent)((Object)context);
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)"\u00a7cIMPALE!"));
    }

    private double calculateDamageMultiplier(int skillLevel) {
        if (this.configFields != null) {
            return 1.5 + this.configFields.calculateValue(skillLevel);
        }
        return 1.5 + (double)skillLevel * 0.02;
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double procChance = this.getProcChance(skillLevel) * 100.0;
        double multiplier = this.calculateDamageMultiplier(skillLevel);
        return List.of("&7Chance: &f" + String.format("%.1f", procChance) + "%", "&7Damage Multiplier: &f" + String.format("%.1f", multiplier) + "x", "&7Ignores armor");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.calculateDamageMultiplier(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("%.1fx Damage", this.calculateDamageMultiplier(skillLevel));
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }
}

