/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.tridents;

import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ConditionalSkill;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class DepthChargeSkill
extends SkillBonus
implements ConditionalSkill {
    public static final String SKILL_ID = "tridents_depth_charge";
    private static final double AOE_RADIUS = 4.0;
    private static final double BASE_DAMAGE_BONUS = 0.5;
    private static final double BASE_AOE_DAMAGE = 0.4;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public DepthChargeSkill() {
        super(SkillType.TRIDENTS, 75, "Depth Charge", "When target is in water, creates an explosion that damages nearby aquatic enemies.", SkillBonusType.CONDITIONAL, 4, SKILL_ID);
    }

    @Override
    public boolean conditionMet(Player player, Object context) {
        if (!(context instanceof EliteMobDamagedByPlayerEvent)) {
            return false;
        }
        EliteMobDamagedByPlayerEvent event = (EliteMobDamagedByPlayerEvent)((Object)context);
        EliteEntity eliteEntity = event.getEliteMobEntity();
        if (eliteEntity == null || eliteEntity.getLivingEntity() == null) {
            return false;
        }
        return eliteEntity.getLivingEntity().isInWater();
    }

    @Override
    public double getConditionalBonus(int skillLevel) {
        if (this.configFields != null) {
            return 0.5 + this.configFields.calculateValue(skillLevel);
        }
        return 0.5 + (double)skillLevel * 0.01;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivate(Player player, EliteMobDamagedByPlayerEvent event) {
        if (!this.isActive(player)) {
            return;
        }
        if (!this.conditionMet(player, (Object)event)) {
            return;
        }
        EliteEntity eliteEntity = event.getEliteMobEntity();
        if (eliteEntity == null || eliteEntity.getLivingEntity() == null) {
            return;
        }
        LivingEntity target = eliteEntity.getLivingEntity();
        int skillLevel = this.getPlayerSkillLevel(player);
        target.getWorld().spawnParticle(Particle.BUBBLE_COLUMN_UP, target.getLocation(), 50, 2.0, 2.0, 2.0, 0.1);
        double aoeDamage = event.getDamage() * this.calculateAoeDamage(skillLevel);
        EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = true;
        try {
            target.getNearbyEntities(4.0, 4.0, 4.0).stream().filter(e -> e instanceof LivingEntity && !(e instanceof Player) && ((LivingEntity)e).isInWater()).forEach(e -> ((LivingEntity)e).damage(aoeDamage, (Entity)player));
        }
        finally {
            EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = false;
        }
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)"\u00a79DEPTH CHARGE!"));
    }

    private double calculateAoeDamage(int skillLevel) {
        if (this.configFields != null) {
            return 0.4 * this.configFields.calculateValue(skillLevel);
        }
        return 0.4 + (double)skillLevel * 0.005;
    }

    private int getPlayerSkillLevel(Player player) {
        return SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.TRIDENTS);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double damageBonus = this.getConditionalBonus(skillLevel) * 100.0;
        double aoeDamage = this.calculateAoeDamage(skillLevel) * 100.0;
        return List.of("&7Active: &fTarget in water", "&7Damage Bonus: &f+" + String.format("%.1f", damageBonus) + "%", "&7AOE Damage: &f" + String.format("%.1f", aoeDamage) + "%", "&7Radius: &f4.0 blocks");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getConditionalBonus(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.1f%% (In Water)", this.getConditionalBonus(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }
}

