/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.swords;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;

public class PoiseSkill
extends SkillBonus {
    public static final String SKILL_ID = "swords_poise";
    private static final double BASE_KNOCKBACK_REDUCTION = 0.2;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public PoiseSkill() {
        super(SkillType.SWORDS, 10, "Poise", "Reduces knockback taken while wielding a sword.", SkillBonusType.PASSIVE, 1, SKILL_ID);
    }

    public static double getKnockbackReduction(int skillLevel) {
        return Math.min(0.5, 0.2 + (double)skillLevel * 0.003);
    }

    public static boolean hasActiveSkill(UUID playerUUID) {
        return activePlayers.contains(playerUUID);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double reduction = PoiseSkill.getKnockbackReduction(skillLevel) * 100.0;
        return List.of("&7Knockback Reduction: &f" + String.format("%.1f", reduction) + "%", "&7Always active when selected");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return PoiseSkill.getKnockbackReduction(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("-%.1f%% Knockback", PoiseSkill.getKnockbackReduction(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }
}

