/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.swords;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ProcSkill;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LacerateSkill
extends SkillBonus
implements ProcSkill {
    public static final String SKILL_ID = "swords_lacerate";
    private static final double BASE_PROC_CHANCE = 0.15;
    private static final double BASE_BLEED_DAMAGE = 2.0;
    private static final int BLEED_DURATION_TICKS = 100;
    private static final int BLEED_TICK_INTERVAL = 20;
    private static final Map<UUID, BukkitRunnable> activeBleedEffects = new HashMap<UUID, BukkitRunnable>();
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public LacerateSkill() {
        super(SkillType.SWORDS, 10, "Lacerate", "Attacks have a chance to cause bleeding, dealing damage over time.", SkillBonusType.PROC, 1, SKILL_ID);
    }

    @Override
    public double getProcChance(int skillLevel) {
        return Math.min(0.5, 0.15 + (double)skillLevel * 0.002);
    }

    @Override
    public void onProc(Player player, Object context) {
        if (!(context instanceof EliteMobDamagedByPlayerEvent)) {
            return;
        }
        EliteMobDamagedByPlayerEvent event = (EliteMobDamagedByPlayerEvent)((Object)context);
        EliteEntity eliteEntity = event.getEliteMobEntity();
        if (eliteEntity == null || eliteEntity.getLivingEntity() == null) {
            return;
        }
        int skillLevel = this.getPlayerSkillLevel(player);
        double bleedDamage = this.calculateBleedDamage(skillLevel);
        this.applyBleedEffect(player, eliteEntity, bleedDamage);
    }

    private void applyBleedEffect(final Player player, final EliteEntity target, final double damagePerTick) {
        final UUID entityUUID = target.getLivingEntity().getUniqueId();
        if (activeBleedEffects.containsKey(entityUUID)) {
            activeBleedEffects.get(entityUUID).cancel();
        }
        BukkitRunnable bleedTask = new BukkitRunnable(this){
            int ticksRemaining = 100;

            public void run() {
                if (this.ticksRemaining <= 0 || target.getLivingEntity() == null || target.getLivingEntity().isDead()) {
                    activeBleedEffects.remove(entityUUID);
                    this.cancel();
                    return;
                }
                LivingEntity entity = target.getLivingEntity();
                if (entity != null && !entity.isDead()) {
                    EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = true;
                    try {
                        entity.damage(damagePerTick, (Entity)player);
                    }
                    finally {
                        EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = false;
                    }
                    entity.getWorld().spawnParticle(Particle.BLOCK, entity.getLocation().add(0.0, 1.0, 0.0), 5, 0.3, 0.3, 0.3, 0.0, (Object)Material.REDSTONE_BLOCK.createBlockData());
                }
                this.ticksRemaining -= 20;
            }
        };
        bleedTask.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 20L);
        activeBleedEffects.put(entityUUID, bleedTask);
    }

    private double calculateBleedDamage(int skillLevel) {
        if (this.configFields != null) {
            return this.configFields.calculateValue(skillLevel);
        }
        return 2.0 + (double)skillLevel * 0.1;
    }

    private int getPlayerSkillLevel(Player player) {
        return SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.SWORDS);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double procChance = this.getProcChance(skillLevel) * 100.0;
        double damage = this.calculateBleedDamage(skillLevel);
        return List.of("&7Chance: &f" + String.format("%.1f", procChance) + "%", "&7Bleed Damage: &f" + String.format("%.1f", damage) + "/s", "&7Duration: &f5 seconds");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.calculateBleedDamage(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.1f Bleed Damage/s", this.calculateBleedDamage(skillLevel));
    }

    @Override
    public void shutdown() {
        for (BukkitRunnable task : activeBleedEffects.values()) {
            task.cancel();
        }
        activeBleedEffects.clear();
        activePlayers.clear();
    }
}

