/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.swords;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.StackingSkill;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FlurrySkill
extends SkillBonus
implements StackingSkill {
    public static final String SKILL_ID = "swords_flurry";
    private static final int MAX_STACKS = 5;
    private static final double ATTACK_SPEED_PER_STACK = 0.05;
    private static final int STACK_DECAY_TICKS = 60;
    private static final Map<UUID, Integer> playerStacks = new HashMap<UUID, Integer>();
    private static final Map<UUID, BukkitRunnable> decayTasks = new HashMap<UUID, BukkitRunnable>();
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public FlurrySkill() {
        super(SkillType.SWORDS, 25, "Flurry", "Consecutive hits increase your attack speed. Stacks decay over time.", SkillBonusType.STACKING, 2, SKILL_ID);
    }

    @Override
    public int getMaxStacks() {
        return 5;
    }

    @Override
    public int getCurrentStacks(Player player) {
        return playerStacks.getOrDefault(player.getUniqueId(), 0);
    }

    @Override
    public void addStack(Player player) {
        UUID uuid = player.getUniqueId();
        int current = playerStacks.getOrDefault(uuid, 0);
        if (current < 5) {
            playerStacks.put(uuid, current + 1);
        }
        this.resetDecayTimer(player);
    }

    @Override
    public void resetStacks(Player player) {
        playerStacks.remove(player.getUniqueId());
        this.cancelDecayTimer(player.getUniqueId());
    }

    @Override
    public double getBonusPerStack(int skillLevel) {
        return 0.05 + (double)skillLevel * 0.001;
    }

    public static double getAttackSpeedBonus(Player player, int skillLevel) {
        if (!activePlayers.contains(player.getUniqueId())) {
            return 0.0;
        }
        int stacks = playerStacks.getOrDefault(player.getUniqueId(), 0);
        double bonusPerStack = 0.05 + (double)skillLevel * 0.001;
        return (double)stacks * bonusPerStack;
    }

    public static boolean hasActiveSkill(UUID playerUUID) {
        return activePlayers.contains(playerUUID);
    }

    private void resetDecayTimer(final Player player) {
        final UUID uuid = player.getUniqueId();
        this.cancelDecayTimer(uuid);
        BukkitRunnable decayTask = new BukkitRunnable(){

            public void run() {
                int current = playerStacks.getOrDefault(uuid, 0);
                if (current > 0) {
                    playerStacks.put(uuid, current - 1);
                    if (current - 1 > 0) {
                        FlurrySkill.this.resetDecayTimer(player);
                    } else {
                        decayTasks.remove(uuid);
                    }
                }
            }
        };
        decayTask.runTaskLater((Plugin)MetadataHandler.PLUGIN, 60L);
        decayTasks.put(uuid, decayTask);
    }

    private void cancelDecayTimer(UUID uuid) {
        BukkitRunnable existing = decayTasks.remove(uuid);
        if (existing != null) {
            existing.cancel();
        }
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        UUID uuid = player.getUniqueId();
        activePlayers.remove(uuid);
        playerStacks.remove(uuid);
        this.cancelDecayTimer(uuid);
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        this.removeBonus(player);
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double bonusPerStack = this.getBonusPerStack(skillLevel) * 100.0;
        return List.of("&7Max Stacks: &f5", "&7Attack Speed per Stack: &f+" + String.format("%.1f", bonusPerStack) + "%", "&7Max Bonus: &f+" + String.format("%.1f", bonusPerStack * 5.0) + "%", "&7Stacks decay after 3 seconds");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getBonusPerStack(skillLevel) * 5.0;
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.1f%% Attack Speed (max)", this.getBonusPerStack(skillLevel) * 5.0 * 100.0);
    }

    @Override
    public void shutdown() {
        for (BukkitRunnable task : decayTasks.values()) {
            task.cancel();
        }
        decayTasks.clear();
        playerStacks.clear();
        activePlayers.clear();
    }
}

