/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.swords;

import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ConditionalSkill;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class FinishingFlourishSkill
extends SkillBonus
implements ConditionalSkill {
    public static final String SKILL_ID = "swords_finishing_flourish";
    private static final double BASE_EXECUTE_BONUS = 0.5;
    private static final double HEALTH_THRESHOLD = 0.3;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public FinishingFlourishSkill() {
        super(SkillType.SWORDS, 50, "Finishing Flourish", "Deal bonus damage to enemies below 30% health.", SkillBonusType.CONDITIONAL, 3, SKILL_ID);
    }

    @Override
    public boolean conditionMet(Player player, Object context) {
        if (!(context instanceof EliteMobDamagedByPlayerEvent)) {
            return false;
        }
        EliteMobDamagedByPlayerEvent event = (EliteMobDamagedByPlayerEvent)((Object)context);
        EliteEntity target = event.getEliteMobEntity();
        if (target == null || target.getLivingEntity() == null) {
            return false;
        }
        LivingEntity entity = target.getLivingEntity();
        double healthPercent = entity.getHealth() / entity.getMaxHealth();
        return healthPercent <= 0.3;
    }

    @Override
    public double getConditionalBonus(int skillLevel) {
        return 0.5 + (double)skillLevel * 0.01;
    }

    public static double applyExecuteBonus(Player player, EliteMobDamagedByPlayerEvent event, double currentDamage) {
        if (!activePlayers.contains(player.getUniqueId())) {
            return currentDamage;
        }
        EliteEntity target = event.getEliteMobEntity();
        if (target == null || target.getLivingEntity() == null) {
            return currentDamage;
        }
        LivingEntity entity = target.getLivingEntity();
        double healthPercent = entity.getHealth() / entity.getMaxHealth();
        if (healthPercent > 0.3) {
            return currentDamage;
        }
        int skillLevel = SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.SWORDS);
        double bonus = 0.5 + (double)skillLevel * 0.01;
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)"\u00a7c\u00a7lFINISHING FLOURISH!"));
        return currentDamage * (1.0 + bonus);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double bonus = this.getConditionalBonus(skillLevel) * 100.0;
        return List.of("&7Execute Damage: &f+" + String.format("%.0f", bonus) + "%", "&7Threshold: &fBelow 30% HP", "&7Finish off weakened enemies!");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getConditionalBonus(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.0f%% Execute Damage", this.getConditionalBonus(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }
}

