/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.swords;

import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ConditionalSkill;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;

public class DuelistSkill
extends SkillBonus
implements ConditionalSkill {
    public static final String SKILL_ID = "swords_duelist";
    private static final double BASE_DAMAGE_BONUS = 0.25;
    private static final double DETECTION_RADIUS = 10.0;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public DuelistSkill() {
        super(SkillType.SWORDS, 50, "Duelist", "Deal bonus damage when fighting a single enemy.", SkillBonusType.CONDITIONAL, 3, SKILL_ID);
    }

    @Override
    public boolean conditionMet(Player player, Object context) {
        if (!(context instanceof EliteMobDamagedByPlayerEvent)) {
            return false;
        }
        EliteMobDamagedByPlayerEvent event = (EliteMobDamagedByPlayerEvent)((Object)context);
        EliteEntity target = event.getEliteMobEntity();
        if (target == null || target.getLivingEntity() == null) {
            return false;
        }
        long nearbyElites = target.getLivingEntity().getNearbyEntities(10.0, 10.0, 10.0).stream().filter(e -> EntityTracker.isEliteMob(e)).filter(e -> !e.getUniqueId().equals(target.getLivingEntity().getUniqueId())).count();
        return nearbyElites == 0L;
    }

    @Override
    public double getConditionalBonus(int skillLevel) {
        return 0.25 + (double)skillLevel * 0.005;
    }

    public static double applyDuelistBonus(Player player, EliteMobDamagedByPlayerEvent event, double currentDamage) {
        if (!activePlayers.contains(player.getUniqueId())) {
            return currentDamage;
        }
        EliteEntity target = event.getEliteMobEntity();
        if (target == null || target.getLivingEntity() == null) {
            return currentDamage;
        }
        long nearbyElites = target.getLivingEntity().getNearbyEntities(10.0, 10.0, 10.0).stream().filter(e -> EntityTracker.isEliteMob(e)).filter(e -> !e.getUniqueId().equals(target.getLivingEntity().getUniqueId())).count();
        if (nearbyElites > 0L) {
            return currentDamage;
        }
        int skillLevel = SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.SWORDS);
        double bonus = 0.25 + (double)skillLevel * 0.005;
        return currentDamage * (1.0 + bonus);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double bonus = this.getConditionalBonus(skillLevel) * 100.0;
        return List.of("&7Damage Bonus: &f+" + String.format("%.1f", bonus) + "%", "&7Condition: No other elites within 10 blocks", "&7Active only in 1v1 situations");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getConditionalBonus(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.1f%% 1v1 Damage", this.getConditionalBonus(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }
}

