/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.hoes;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.CooldownSkill;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class SpectralScytheSkill
extends SkillBonus
implements CooldownSkill {
    public static final String SKILL_ID = "hoes_spectral_scythe";
    private static final long BASE_COOLDOWN = 25L;
    private static final double PROJECTILE_RANGE = 10.0;
    private static final double BASE_DAMAGE_MULTIPLIER = 2.0;
    private static final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public SpectralScytheSkill() {
        super(SkillType.HOES, 75, "Spectral Scythe", "Launch a spectral scythe projectile that pierces through enemies.", SkillBonusType.COOLDOWN, 4, SKILL_ID);
    }

    @Override
    public long getCooldownSeconds(int skillLevel) {
        long reduction = (long)((double)skillLevel * 0.2);
        return Math.max(10L, 25L - reduction);
    }

    @Override
    public boolean isOnCooldown(Player player) {
        Long cooldownEnd = cooldowns.get(player.getUniqueId());
        if (cooldownEnd == null) {
            return false;
        }
        if (System.currentTimeMillis() >= cooldownEnd) {
            cooldowns.remove(player.getUniqueId());
            return false;
        }
        return true;
    }

    @Override
    public void startCooldown(Player player, int skillLevel) {
        long cooldownMs = this.getCooldownSeconds(skillLevel) * 1000L;
        cooldowns.put(player.getUniqueId(), System.currentTimeMillis() + cooldownMs);
    }

    @Override
    public long getRemainingCooldown(Player player) {
        Long cooldownEnd = cooldowns.get(player.getUniqueId());
        if (cooldownEnd == null) {
            return 0L;
        }
        long remaining = (cooldownEnd - System.currentTimeMillis()) / 1000L;
        return Math.max(0L, remaining);
    }

    @Override
    public void endCooldown(Player player) {
        cooldowns.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player, Object event) {
        if (this.isOnCooldown(player)) {
            long remaining = this.getRemainingCooldown(player);
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)("\u00a7cSpectral Scythe on cooldown: " + remaining + "s")));
            return;
        }
        int skillLevel = this.getPlayerSkillLevel(player);
        this.launchSpectralScythe(player, skillLevel);
        this.startCooldown(player, skillLevel);
    }

    private void launchSpectralScythe(final Player player, int skillLevel) {
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_VEX_CHARGE, 1.0f, 0.5f);
        final Vector direction = player.getLocation().getDirection().normalize();
        final Location startLoc = player.getEyeLocation();
        final double baseDamage = this.calculateDamage(skillLevel);
        final HashSet hitEntities = new HashSet();
        new BukkitRunnable(this){
            Location currentLoc;
            double distance;
            {
                this.currentLoc = startLoc.clone();
                this.distance = 0.0;
            }

            public void run() {
                if (this.distance > 10.0) {
                    this.cancel();
                    return;
                }
                this.currentLoc.add(direction.clone().multiply(0.5));
                this.distance += 0.5;
                this.currentLoc.getWorld().spawnParticle(Particle.SOUL, this.currentLoc, 3, 0.1, 0.1, 0.1, 0.02);
                this.currentLoc.getWorld().spawnParticle(Particle.SWEEP_ATTACK, this.currentLoc, 1, 0.1, 0.1, 0.1, 0.0);
                EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = true;
                try {
                    this.currentLoc.getWorld().getNearbyEntities(this.currentLoc, 1.0, 1.0, 1.0).stream().filter(e -> e instanceof LivingEntity && !(e instanceof Player)).filter(e -> !hitEntities.contains(e.getUniqueId())).forEach(e -> {
                        LivingEntity target = (LivingEntity)e;
                        target.damage(baseDamage, (Entity)player);
                        hitEntities.add(e.getUniqueId());
                    });
                }
                finally {
                    EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = false;
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private double calculateDamage(int skillLevel) {
        if (this.configFields != null) {
            return this.configFields.calculateValue(skillLevel);
        }
        return 2.0 + (double)skillLevel * 0.05;
    }

    private int getPlayerSkillLevel(Player player) {
        return SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.HOES);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        this.endCooldown(player);
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        this.endCooldown(player);
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        long cooldown = this.getCooldownSeconds(skillLevel);
        double damagePercent = this.calculateDamage(skillLevel) * 100.0;
        return List.of("&7Damage: &f" + String.format("%.0f", damagePercent) + "% weapon damage", "&7Range: &f" + String.format("%.1f", 10.0) + " blocks", "&7Cooldown: &f" + cooldown + " seconds", "&7Pierces through enemies");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.calculateDamage(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("%.0f%% Projectile Damage", this.calculateDamage(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        cooldowns.clear();
        activePlayers.clear();
    }
}

