/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.hoes;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.StackingSkill;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SoulSiphonSkill
extends SkillBonus
implements StackingSkill {
    public static final String SKILL_ID = "hoes_soul_siphon";
    private static final int MAX_STACKS = 10;
    private static final long STACK_DECAY_TIME = 30000L;
    private static final double BASE_BONUS_PER_STACK = 0.05;
    private static final Map<UUID, Integer> soulStacks = new HashMap<UUID, Integer>();
    private static final Map<UUID, Long> lastKillTime = new HashMap<UUID, Long>();
    private static final Map<UUID, BukkitRunnable> decayTasks = new HashMap<UUID, BukkitRunnable>();
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public SoulSiphonSkill() {
        super(SkillType.HOES, 25, "Soul Siphon", "Each kill grants a stacking damage bonus that decays over time.", SkillBonusType.STACKING, 2, SKILL_ID);
    }

    @Override
    public int getMaxStacks() {
        return 10;
    }

    @Override
    public int getCurrentStacks(Player player) {
        this.checkAndDecayStacks(player);
        return soulStacks.getOrDefault(player.getUniqueId(), 0);
    }

    @Override
    public void addStack(Player player) {
        UUID uuid = player.getUniqueId();
        int current = this.getCurrentStacks(player);
        if (current < 10) {
            soulStacks.put(uuid, current + 1);
            player.getWorld().spawnParticle(Particle.SOUL, player.getLocation().add(0.0, 1.0, 0.0), 5, 0.3, 0.5, 0.3, 0.02);
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)("\u00a75Soul Siphon: " + (current + 1) + "/10")));
        }
        lastKillTime.put(uuid, System.currentTimeMillis());
        this.scheduleDecay(player);
    }

    @Override
    public void resetStacks(Player player) {
        UUID uuid = player.getUniqueId();
        soulStacks.remove(uuid);
        lastKillTime.remove(uuid);
        BukkitRunnable task = decayTasks.remove(uuid);
        if (task != null) {
            task.cancel();
        }
    }

    @Override
    public double getBonusPerStack(int skillLevel) {
        if (this.configFields != null) {
            return this.configFields.calculateValue(skillLevel) / 10.0;
        }
        return 0.05 + (double)skillLevel * 0.001;
    }

    private void checkAndDecayStacks(Player player) {
        Long lastKill = lastKillTime.get(player.getUniqueId());
        if (lastKill != null && System.currentTimeMillis() - lastKill > 30000L) {
            this.resetStacks(player);
        }
    }

    private void scheduleDecay(final Player player) {
        final UUID uuid = player.getUniqueId();
        BukkitRunnable oldTask = decayTasks.remove(uuid);
        if (oldTask != null) {
            oldTask.cancel();
        }
        BukkitRunnable decayTask = new BukkitRunnable(){

            public void run() {
                SoulSiphonSkill.this.resetStacks(player);
                decayTasks.remove(uuid);
                if (player.isOnline()) {
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)"\u00a77Soul Siphon stacks decayed"));
                }
            }
        };
        decayTask.runTaskLater((Plugin)MetadataHandler.PLUGIN, 600L);
        decayTasks.put(uuid, decayTask);
    }

    public static void onKill(Player player) {
        if (!activePlayers.contains(player.getUniqueId())) {
            return;
        }
        SkillBonus skill = SkillBonusRegistry.getSkillById(SKILL_ID);
        if (skill instanceof SoulSiphonSkill) {
            SoulSiphonSkill soulSiphon = (SoulSiphonSkill)skill;
            soulSiphon.addStack(player);
        }
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        this.resetStacks(player);
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        this.resetStacks(player);
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double bonusPerStack = this.getBonusPerStack(skillLevel) * 100.0;
        double maxBonus = bonusPerStack * 10.0;
        return List.of("&7Bonus per Stack: &f+" + String.format("%.1f", bonusPerStack) + "%", "&7Max Stacks: &f10", "&7Max Bonus: &f+" + String.format("%.1f", maxBonus) + "%", "&7Stacks decay after 30s");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getBonusPerStack(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.1f%% per Soul Stack", this.getBonusPerStack(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        for (BukkitRunnable task : decayTasks.values()) {
            task.cancel();
        }
        decayTasks.clear();
        soulStacks.clear();
        lastKillTime.clear();
        activePlayers.clear();
    }
}

