/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.hoes;

import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ProcSkill;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ScytheSweepSkill
extends SkillBonus
implements ProcSkill {
    public static final String SKILL_ID = "hoes_scythe_sweep";
    private static final double BASE_PROC_CHANCE = 0.3;
    private static final double SWEEP_RADIUS = 3.0;
    private static final double BASE_SWEEP_MULTIPLIER = 0.5;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public ScytheSweepSkill() {
        super(SkillType.HOES, 50, "Scythe Sweep", "Attacks have a chance to sweep and hit nearby enemies.", SkillBonusType.PROC, 3, SKILL_ID);
    }

    @Override
    public double getProcChance(int skillLevel) {
        return Math.min(0.6, 0.3 + (double)skillLevel * 0.004);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onProc(Player player, Object context) {
        if (!(context instanceof EliteMobDamagedByPlayerEvent)) {
            return;
        }
        EliteMobDamagedByPlayerEvent event = (EliteMobDamagedByPlayerEvent)((Object)context);
        EliteEntity eliteEntity = event.getEliteMobEntity();
        if (eliteEntity == null || eliteEntity.getLivingEntity() == null) {
            return;
        }
        LivingEntity target = eliteEntity.getLivingEntity();
        double originalDamage = event.getDamage();
        int skillLevel = this.getPlayerSkillLevel(player);
        double sweepDamage = originalDamage * this.calculateSweepMultiplier(skillLevel);
        target.getWorld().spawnParticle(Particle.SWEEP_ATTACK, target.getLocation().add(0.0, 0.5, 0.0), 3, 1.0, 0.2, 1.0, 0.0);
        EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = true;
        try {
            target.getNearbyEntities(3.0, 3.0, 3.0).stream().filter(e -> e instanceof LivingEntity && !(e instanceof Player) && !e.equals((Object)target)).forEach(e -> ((LivingEntity)e).damage(sweepDamage, (Entity)player));
        }
        finally {
            EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = false;
        }
    }

    private double calculateSweepMultiplier(int skillLevel) {
        if (this.configFields != null) {
            return this.configFields.calculateValue(skillLevel);
        }
        return 0.5 + (double)skillLevel * 0.01;
    }

    private int getPlayerSkillLevel(Player player) {
        return SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.HOES);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double procChance = this.getProcChance(skillLevel) * 100.0;
        double sweepPercent = this.calculateSweepMultiplier(skillLevel) * 100.0;
        return List.of("&7Chance: &f" + String.format("%.1f", procChance) + "%", "&7Sweep Damage: &f" + String.format("%.0f", sweepPercent) + "% of hit", "&7Radius: &f" + String.format("%.1f", 3.0) + " blocks", "&7AoE cleave attack");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.calculateSweepMultiplier(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("%.0f%% AoE Sweep", this.calculateSweepMultiplier(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }
}

