/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.hoes;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ConditionalSkill;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;

public class ReapWhatYouSowSkill
extends SkillBonus
implements ConditionalSkill {
    public static final String SKILL_ID = "hoes_reap_what_you_sow";
    private static final double HEALTH_THRESHOLD = 0.5;
    private static final double BASE_BONUS = 0.5;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public ReapWhatYouSowSkill() {
        super(SkillType.HOES, 50, "Reap What You Sow", "Deal more damage when you're at low health - risk for reward.", SkillBonusType.CONDITIONAL, 3, SKILL_ID);
    }

    @Override
    public boolean conditionMet(Player player, Object context) {
        return player.getHealth() / player.getMaxHealth() < 0.5;
    }

    @Override
    public double getConditionalBonus(int skillLevel) {
        if (this.configFields != null) {
            return this.configFields.calculateValue(skillLevel);
        }
        return 0.5 + (double)skillLevel * 0.01;
    }

    public static double calculateRiskBonus(Player player, int skillLevel) {
        double healthPercent = player.getHealth() / player.getMaxHealth();
        if (healthPercent >= 0.5) {
            return 0.0;
        }
        SkillBonus skill = SkillBonusRegistry.getSkillById(SKILL_ID);
        double baseBonus = 0.5;
        if (skill instanceof ReapWhatYouSowSkill) {
            ReapWhatYouSowSkill reapSkill = (ReapWhatYouSowSkill)skill;
            baseBonus = reapSkill.getConditionalBonus(skillLevel);
        }
        double riskMultiplier = 1.0 + (0.5 - healthPercent) * 2.0;
        return baseBonus * riskMultiplier;
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double bonusPercent = this.getConditionalBonus(skillLevel) * 100.0;
        double maxBonus = bonusPercent * 2.0;
        return List.of("&7Base Bonus: &f+" + String.format("%.0f", bonusPercent) + "%", "&7Max Bonus: &f+" + String.format("%.0f", maxBonus) + "% (at 0% HP)", "&7Condition: Below 50% health", "&7Risk equals reward");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getConditionalBonus(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.0f%% at Low HP", this.getConditionalBonus(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }
}

