/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.hoes;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.CooldownSkill;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class DeathsEmbraceSkill
extends SkillBonus
implements CooldownSkill {
    public static final String SKILL_ID = "hoes_deaths_embrace";
    private static final long BASE_COOLDOWN = 60L;
    private static final double HEAL_PERCENT = 0.2;
    private static final double BASE_PASSIVE_BONUS = 0.05;
    private static final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public DeathsEmbraceSkill() {
        super(SkillType.HOES, 75, "Death's Embrace", "Cheat death once per minute, reviving with health.", SkillBonusType.COOLDOWN, 4, SKILL_ID);
    }

    @Override
    public long getCooldownSeconds(int skillLevel) {
        long reduction = (long)((double)skillLevel * 0.4);
        return Math.max(30L, 60L - reduction);
    }

    @Override
    public boolean isOnCooldown(Player player) {
        Long cooldownEnd = cooldowns.get(player.getUniqueId());
        if (cooldownEnd == null) {
            return false;
        }
        if (System.currentTimeMillis() >= cooldownEnd) {
            cooldowns.remove(player.getUniqueId());
            return false;
        }
        return true;
    }

    @Override
    public void startCooldown(Player player, int skillLevel) {
        long cooldownMs = this.getCooldownSeconds(skillLevel) * 1000L;
        cooldowns.put(player.getUniqueId(), System.currentTimeMillis() + cooldownMs);
    }

    @Override
    public long getRemainingCooldown(Player player) {
        Long cooldownEnd = cooldowns.get(player.getUniqueId());
        if (cooldownEnd == null) {
            return 0L;
        }
        long remaining = (cooldownEnd - System.currentTimeMillis()) / 1000L;
        return Math.max(0L, remaining);
    }

    @Override
    public void endCooldown(Player player) {
        cooldowns.remove(player.getUniqueId());
    }

    public static boolean preventDeath(Player player) {
        if (!activePlayers.contains(player.getUniqueId())) {
            return false;
        }
        SkillBonus skill = SkillBonusRegistry.getSkillById(SKILL_ID);
        if (!(skill instanceof DeathsEmbraceSkill)) {
            return false;
        }
        DeathsEmbraceSkill deathsEmbrace = (DeathsEmbraceSkill)skill;
        if (deathsEmbrace.isOnCooldown(player)) {
            return false;
        }
        int skillLevel = SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.HOES);
        player.setHealth(player.getMaxHealth() * 0.2);
        player.getWorld().spawnParticle(Particle.SOUL, player.getLocation(), 50, 1.0, 1.0, 1.0, 0.1);
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_WITHER_SPAWN, 0.5f, 1.5f);
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)"\u00a75Death's Embrace saved you!"));
        deathsEmbrace.startCooldown(player, skillLevel);
        return true;
    }

    public double getPassiveDamageBonus(int skillLevel) {
        if (this.configFields != null) {
            return this.configFields.calculateValue(skillLevel);
        }
        return 0.05 + (double)skillLevel * 0.001;
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        this.endCooldown(player);
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        this.endCooldown(player);
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        long cooldown = this.getCooldownSeconds(skillLevel);
        double healPercent = 20.0;
        double passiveBonus = this.getPassiveDamageBonus(skillLevel) * 100.0;
        return List.of("&7Prevents fatal damage", "&7Heals to: &f" + String.format("%.0f", healPercent) + "% HP", "&7Passive Bonus: &f+" + String.format("%.1f", passiveBonus) + "% damage", "&7Cooldown: &f" + cooldown + " seconds");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getPassiveDamageBonus(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.1f%% Damage & Death Prevention", this.getPassiveDamageBonus(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        cooldowns.clear();
        activePlayers.clear();
    }
}

