/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.hoes;

import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ProcSkill;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class DeathMarkSkill
extends SkillBonus
implements ProcSkill {
    public static final String SKILL_ID = "hoes_death_mark";
    private static final double BASE_PROC_CHANCE = 0.25;
    private static final long MARK_DURATION = 15000L;
    private static final double BASE_DAMAGE_BONUS = 0.5;
    private static final Map<UUID, UUID> markedTargets = new HashMap<UUID, UUID>();
    private static final Map<UUID, Long> markExpiry = new HashMap<UUID, Long>();
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public DeathMarkSkill() {
        super(SkillType.HOES, 25, "Death Mark", "Mark enemies for death, causing them to take bonus damage.", SkillBonusType.PROC, 2, SKILL_ID);
    }

    @Override
    public double getProcChance(int skillLevel) {
        return Math.min(0.5, 0.25 + (double)skillLevel * 0.003);
    }

    @Override
    public void onProc(Player player, Object context) {
        if (!(context instanceof EliteMobDamagedByPlayerEvent)) {
            return;
        }
        EliteMobDamagedByPlayerEvent event = (EliteMobDamagedByPlayerEvent)((Object)context);
        EliteEntity eliteEntity = event.getEliteMobEntity();
        if (eliteEntity == null || eliteEntity.getLivingEntity() == null) {
            return;
        }
        LivingEntity target = eliteEntity.getLivingEntity();
        UUID entityUUID = target.getUniqueId();
        markedTargets.put(entityUUID, player.getUniqueId());
        markExpiry.put(entityUUID, System.currentTimeMillis() + 15000L);
        target.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 300, 0));
        target.getWorld().spawnParticle(Particle.SCULK_SOUL, target.getLocation().add(0.0, 1.0, 0.0), 20, 0.5, 0.5, 0.5, 0.05);
    }

    public static boolean isMarkedForDeath(LivingEntity target, Player player) {
        UUID entityUUID = target.getUniqueId();
        UUID markerUUID = markedTargets.get(entityUUID);
        if (markerUUID == null) {
            return false;
        }
        Long expiry = markExpiry.get(entityUUID);
        if (expiry == null || System.currentTimeMillis() > expiry) {
            markedTargets.remove(entityUUID);
            markExpiry.remove(entityUUID);
            return false;
        }
        return markerUUID.equals(player.getUniqueId());
    }

    public double getMarkDamageBonus(int skillLevel) {
        if (this.configFields != null) {
            return this.configFields.calculateValue(skillLevel);
        }
        return 0.5 + (double)skillLevel * 0.01;
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
        UUID playerUUID = player.getUniqueId();
        markedTargets.entrySet().removeIf(entry -> ((UUID)entry.getValue()).equals(playerUUID));
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        this.removeBonus(player);
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double procChance = this.getProcChance(skillLevel) * 100.0;
        double damageBonus = this.getMarkDamageBonus(skillLevel) * 100.0;
        return List.of("&7Chance: &f" + String.format("%.1f", procChance) + "%", "&7Mark Damage: &f+" + String.format("%.0f", damageBonus) + "%", "&7Duration: &f15 seconds", "&7Marked enemies glow");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getMarkDamageBonus(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.0f%% vs Marked", this.getMarkDamageBonus(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        markedTargets.clear();
        markExpiry.clear();
        activePlayers.clear();
    }
}

