/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.bows;

import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ProcSkill;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class RicochetSkill
extends SkillBonus
implements ProcSkill {
    public static final String SKILL_ID = "bows_ricochet";
    private static final double BASE_PROC_CHANCE = 0.15;
    private static final double RICOCHET_RANGE = 5.0;
    private static final double BASE_RICOCHET_DAMAGE = 0.5;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public RicochetSkill() {
        super(SkillType.BOWS, 50, "Ricochet", "Arrows can bounce to nearby enemies.", SkillBonusType.PROC, 3, SKILL_ID);
    }

    @Override
    public double getProcChance(int skillLevel) {
        return Math.min(0.35, 0.15 + (double)skillLevel * 0.002);
    }

    @Override
    public void onProc(Player player, Object context) {
        if (!(context instanceof EliteMobDamagedByPlayerEvent)) {
            return;
        }
        EliteMobDamagedByPlayerEvent event = (EliteMobDamagedByPlayerEvent)((Object)context);
        if (event.getEliteMobEntity().getLivingEntity() == null) {
            return;
        }
        LivingEntity target = event.getEliteMobEntity().getLivingEntity();
        int skillLevel = SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.BOWS);
        double ricochetDamage = event.getDamage() * this.getRicochetDamageMultiplier(skillLevel);
        target.getNearbyEntities(5.0, 5.0, 5.0).stream().filter(e -> e instanceof LivingEntity && !e.equals((Object)target) && !(e instanceof Player)).map(e -> (LivingEntity)e).min(Comparator.comparingDouble(e -> e.getLocation().distanceSquared(target.getLocation()))).ifPresent(bounceTarget -> {
            EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = true;
            try {
                bounceTarget.damage(ricochetDamage, (Entity)player);
            }
            finally {
                EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = false;
            }
            bounceTarget.getWorld().spawnParticle(Particle.CRIT, bounceTarget.getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3, 0.1);
        });
    }

    private double getRicochetDamageMultiplier(int skillLevel) {
        return 0.5 + (double)skillLevel * 0.005;
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        return List.of("&7Proc Chance: &f" + String.format("%.1f", this.getProcChance(skillLevel) * 100.0) + "%", "&7Ricochet Damage: &f" + String.format("%.0f", this.getRicochetDamageMultiplier(skillLevel) * 100.0) + "%", "&7Range: &f5 blocks");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getRicochetDamageMultiplier(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("%.0f%% ricochet damage", this.getRicochetDamageMultiplier(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }
}

