/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.bows;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ConditionalSkill;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;

public class PackHunterSkill
extends SkillBonus
implements ConditionalSkill {
    public static final String SKILL_ID = "bows_pack_hunter";
    private static final double ALLY_RANGE = 10.0;
    private static final double BASE_BONUS_PER_ALLY = 0.08;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public PackHunterSkill() {
        super(SkillType.BOWS, 10, "Pack Hunter", "Deal bonus damage for each nearby ally.", SkillBonusType.CONDITIONAL, 1, SKILL_ID);
    }

    @Override
    public boolean conditionMet(Player player, Object context) {
        long nearbyPlayers = player.getNearbyEntities(10.0, 10.0, 10.0).stream().filter(e -> e instanceof Player && !e.equals((Object)player)).count();
        return nearbyPlayers >= 1L;
    }

    @Override
    public double getConditionalBonus(int skillLevel) {
        return 0.08 + (double)skillLevel * 0.001;
    }

    public double calculateBonus(Player player, int skillLevel) {
        long nearbyPlayers = player.getNearbyEntities(10.0, 10.0, 10.0).stream().filter(e -> e instanceof Player && !e.equals((Object)player)).count();
        return this.getConditionalBonus(skillLevel) * (double)Math.min(nearbyPlayers, 3L);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        return List.of("&7Bonus per Ally: &f" + String.format("%.1f", this.getConditionalBonus(skillLevel) * 100.0) + "%", "&7Max Allies: &f3", "&7Range: &f10 blocks");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getConditionalBonus(skillLevel) * 3.0;
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.1f%% damage per ally", this.getConditionalBonus(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }
}

