/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.bows;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ConditionalSkill;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;

public class OverdrawSkill
extends SkillBonus
implements ConditionalSkill {
    public static final String SKILL_ID = "bows_overdraw";
    private static final long FULL_DRAW_TIME = 1000L;
    private static final double BASE_BONUS = 0.15;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();
    private static final Map<UUID, Long> drawStartTimes = new HashMap<UUID, Long>();

    public OverdrawSkill() {
        super(SkillType.BOWS, 25, "Overdraw", "Holding your bow longer increases damage.", SkillBonusType.CONDITIONAL, 2, SKILL_ID);
    }

    public static void startDrawing(UUID uuid) {
        drawStartTimes.put(uuid, System.currentTimeMillis());
    }

    public static void stopDrawing(UUID uuid) {
        drawStartTimes.remove(uuid);
    }

    public static long getDrawTime(UUID uuid) {
        Long startTime = drawStartTimes.get(uuid);
        if (startTime == null) {
            return 0L;
        }
        return System.currentTimeMillis() - startTime;
    }

    @Override
    public boolean conditionMet(Player player, Object context) {
        return OverdrawSkill.getDrawTime(player.getUniqueId()) >= 1000L;
    }

    @Override
    public double getConditionalBonus(int skillLevel) {
        return 0.15 + (double)skillLevel * 0.003;
    }

    public double calculateBonus(Player player, int skillLevel) {
        long drawTime = OverdrawSkill.getDrawTime(player.getUniqueId());
        if (drawTime < 1000L) {
            return 0.0;
        }
        double overdrawMultiplier = Math.min((double)(drawTime - 1000L) / 1000.0, 2.0);
        return this.getConditionalBonus(skillLevel) * (1.0 + overdrawMultiplier);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
        drawStartTimes.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
        drawStartTimes.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        return List.of("&7Base Bonus: &f" + String.format("%.1f", this.getConditionalBonus(skillLevel) * 100.0) + "%", "&7Max Overdraw: &f3x bonus", "&7Requires full draw");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getConditionalBonus(skillLevel) * 3.0;
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.1f%% damage (overdraw)", this.getConditionalBonus(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
        drawStartTimes.clear();
    }
}

