/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.bows;

import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ProcSkill;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class HuntersMarkSkill
extends SkillBonus
implements ProcSkill {
    public static final String SKILL_ID = "bows_hunters_mark";
    private static final double BASE_PROC_CHANCE = 0.25;
    private static final long MARK_DURATION = 10000L;
    private static final double BASE_BONUS_DAMAGE = 0.2;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();
    private static final Map<UUID, UUID> markedTargets = new HashMap<UUID, UUID>();
    private static final Map<UUID, Long> markExpiry = new HashMap<UUID, Long>();

    public HuntersMarkSkill() {
        super(SkillType.BOWS, 25, "Hunter's Mark", "Mark enemies to take increased damage from you.", SkillBonusType.PROC, 2, SKILL_ID);
    }

    @Override
    public double getProcChance(int skillLevel) {
        return Math.min(0.5, 0.25 + (double)skillLevel * 0.0025);
    }

    @Override
    public void onProc(Player player, Object context) {
        if (!(context instanceof EliteMobDamagedByPlayerEvent)) {
            return;
        }
        EliteMobDamagedByPlayerEvent event = (EliteMobDamagedByPlayerEvent)((Object)context);
        if (event.getEliteMobEntity().getLivingEntity() == null) {
            return;
        }
        LivingEntity target = event.getEliteMobEntity().getLivingEntity();
        markedTargets.put(target.getUniqueId(), player.getUniqueId());
        markExpiry.put(target.getUniqueId(), System.currentTimeMillis() + 10000L);
        target.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 200, 0));
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)"\u00a76TARGET MARKED!"));
    }

    public static boolean isMarkedBy(LivingEntity target, Player player) {
        UUID markerUUID = markedTargets.get(target.getUniqueId());
        if (markerUUID == null) {
            return false;
        }
        Long expiry = markExpiry.get(target.getUniqueId());
        if (expiry == null || System.currentTimeMillis() > expiry) {
            markedTargets.remove(target.getUniqueId());
            markExpiry.remove(target.getUniqueId());
            return false;
        }
        return markerUUID.equals(player.getUniqueId());
    }

    public double getMarkBonus(int skillLevel) {
        return 0.2 + (double)skillLevel * 0.003;
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        return List.of("&7Proc Chance: &f" + String.format("%.1f", this.getProcChance(skillLevel) * 100.0) + "%", "&7Mark Bonus: &f" + String.format("%.1f", this.getMarkBonus(skillLevel) * 100.0) + "% damage", "&7Duration: &f10 seconds");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getMarkBonus(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.1f%% to marked targets", this.getMarkBonus(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
        markedTargets.clear();
        markExpiry.clear();
    }
}

