/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.bows;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.CooldownSkill;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DeadEyeSkill
extends SkillBonus
implements CooldownSkill {
    public static final String SKILL_ID = "bows_dead_eye";
    private static final long BASE_COOLDOWN = 45L;
    private static final double BASE_DAMAGE_MULTIPLIER = 2.5;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();
    private static final Set<UUID> onCooldown = new HashSet<UUID>();
    private static final Map<UUID, Long> cooldownEndTimes = new HashMap<UUID, Long>();

    public DeadEyeSkill() {
        super(SkillType.BOWS, 75, "Dead Eye", "Critical shots deal massive bonus damage.", SkillBonusType.COOLDOWN, 4, SKILL_ID);
    }

    @Override
    public long getCooldownSeconds(int skillLevel) {
        return Math.max(20L, 45L - (long)(skillLevel / 5));
    }

    @Override
    public boolean isOnCooldown(Player player) {
        return onCooldown.contains(player.getUniqueId());
    }

    @Override
    public void startCooldown(final Player player, int skillLevel) {
        UUID uuid = player.getUniqueId();
        long cooldownMs = this.getCooldownSeconds(skillLevel) * 1000L;
        onCooldown.add(uuid);
        cooldownEndTimes.put(uuid, System.currentTimeMillis() + cooldownMs);
        new BukkitRunnable(){

            public void run() {
                DeadEyeSkill.this.endCooldown(player);
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, this.getCooldownSeconds(skillLevel) * 20L);
    }

    @Override
    public long getRemainingCooldown(Player player) {
        Long endTime = cooldownEndTimes.get(player.getUniqueId());
        if (endTime == null) {
            return 0L;
        }
        long remaining = endTime - System.currentTimeMillis();
        return remaining > 0L ? remaining / 1000L : 0L;
    }

    @Override
    public void endCooldown(Player player) {
        onCooldown.remove(player.getUniqueId());
        cooldownEndTimes.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player, Object event) {
        if (!(event instanceof EliteMobDamagedByPlayerEvent)) {
            return;
        }
        EliteMobDamagedByPlayerEvent damageEvent = (EliteMobDamagedByPlayerEvent)((Object)event);
        int skillLevel = SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.BOWS);
        double multiplier = this.getDamageMultiplier(skillLevel);
        damageEvent.setDamage(damageEvent.getDamage() * multiplier);
        if (damageEvent.getEliteMobEntity().getLivingEntity() != null) {
            damageEvent.getEliteMobEntity().getLivingEntity().getWorld().spawnParticle(Particle.ENCHANTED_HIT, damageEvent.getEliteMobEntity().getLivingEntity().getLocation().add(0.0, 1.0, 0.0), 30, 0.5, 0.5, 0.5, 0.2);
        }
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)"\u00a7c\u00a7lDEAD EYE!"));
    }

    private double getDamageMultiplier(int skillLevel) {
        return 2.5 + (double)skillLevel * 0.02;
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
        this.endCooldown(player);
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
        this.endCooldown(player);
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        return List.of("&7Damage Multiplier: &f" + String.format("%.1f", this.getDamageMultiplier(skillLevel)) + "x", "&7Cooldown: &f" + this.getCooldownSeconds(skillLevel) + "s", "&7Triggers on critical hits");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getDamageMultiplier(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("%.1fx critical damage", this.getDamageMultiplier(skillLevel));
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
        onCooldown.clear();
        cooldownEndTimes.clear();
    }
}

