/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.axes;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusEventHandler;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ToggleSkill;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;

public class RecklessFurySkill
extends SkillBonus
implements ToggleSkill {
    public static final String SKILL_ID = "axes_reckless_fury";
    private static final double BASE_DAMAGE_BONUS = 0.3;
    private static final double BASE_DAMAGE_TAKEN = 0.25;
    private static final Set<UUID> activePlayers = new HashSet<UUID>();
    private static final Set<UUID> toggledPlayers = new HashSet<UUID>();

    public RecklessFurySkill() {
        super(SkillType.AXES, 50, "Reckless Fury", "Toggle: Deal and take more damage.", SkillBonusType.TOGGLE, 3, SKILL_ID);
    }

    @Override
    public void toggle(Player player) {
        if (toggledPlayers.contains(player.getUniqueId())) {
            this.disable(player);
        } else {
            this.enable(player);
        }
    }

    @Override
    public boolean isToggled(Player player) {
        return toggledPlayers.contains(player.getUniqueId());
    }

    @Override
    public void enable(Player player) {
        toggledPlayers.add(player.getUniqueId());
        SkillBonusEventHandler.setToggle(player.getUniqueId(), SKILL_ID, true);
        player.sendMessage("\u00a7c\u00a7lReckless Fury \u00a7aenabled");
    }

    @Override
    public void disable(Player player) {
        toggledPlayers.remove(player.getUniqueId());
        SkillBonusEventHandler.setToggle(player.getUniqueId(), SKILL_ID, false);
        player.sendMessage("\u00a7c\u00a7lReckless Fury \u00a7cdisabled");
    }

    @Override
    public double getPositiveBonus(int skillLevel) {
        return 0.3 + (double)skillLevel * 0.004;
    }

    @Override
    public double getNegativeEffect(int skillLevel) {
        return Math.max(0.1, 0.25 - (double)skillLevel * 0.002);
    }

    public static double getDamageMultiplier(Player player, int skillLevel) {
        if (!toggledPlayers.contains(player.getUniqueId())) {
            return 1.0;
        }
        return 1.3 + (double)skillLevel * 0.004;
    }

    public static double getDamageTakenMultiplier(Player player, int skillLevel) {
        if (!toggledPlayers.contains(player.getUniqueId())) {
            return 1.0;
        }
        return 1.0 + Math.max(0.1, 0.25 - (double)skillLevel * 0.002);
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
        toggledPlayers.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        this.removeBonus(player);
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        return List.of("&aBonus Damage: &f+" + String.format("%.0f", this.getPositiveBonus(skillLevel) * 100.0) + "%", "&cExtra Damage Taken: &f+" + String.format("%.0f", this.getNegativeEffect(skillLevel) * 100.0) + "%");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getPositiveBonus(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.0f%% Damage (toggle)", this.getPositiveBonus(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
        toggledPlayers.clear();
    }
}

