/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.axes;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.StackingSkill;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MomentumSkill
extends SkillBonus
implements StackingSkill {
    public static final String SKILL_ID = "axes_momentum";
    private static final int MAX_STACKS = 8;
    private static final double DAMAGE_PER_STACK = 0.04;
    private static final int DECAY_TICKS = 80;
    private static final Map<UUID, Integer> playerStacks = new HashMap<UUID, Integer>();
    private static final Map<UUID, BukkitRunnable> decayTasks = new HashMap<UUID, BukkitRunnable>();
    private static final Set<UUID> activePlayers = new HashSet<UUID>();

    public MomentumSkill() {
        super(SkillType.AXES, 50, "Momentum", "Build up damage with each consecutive hit.", SkillBonusType.STACKING, 3, SKILL_ID);
    }

    @Override
    public int getMaxStacks() {
        return 8;
    }

    @Override
    public int getCurrentStacks(Player player) {
        return playerStacks.getOrDefault(player.getUniqueId(), 0);
    }

    @Override
    public void addStack(Player player) {
        UUID uuid = player.getUniqueId();
        int current = playerStacks.getOrDefault(uuid, 0);
        if (current < 8) {
            playerStacks.put(uuid, current + 1);
        }
        this.resetDecayTimer(player);
    }

    @Override
    public void resetStacks(Player player) {
        playerStacks.remove(player.getUniqueId());
        this.cancelDecayTimer(player.getUniqueId());
    }

    @Override
    public double getBonusPerStack(int skillLevel) {
        return 0.04 + (double)skillLevel * 5.0E-4;
    }

    public static double getDamageMultiplier(Player player, int skillLevel) {
        if (!activePlayers.contains(player.getUniqueId())) {
            return 1.0;
        }
        int stacks = playerStacks.getOrDefault(player.getUniqueId(), 0);
        double bonus = (0.04 + (double)skillLevel * 5.0E-4) * (double)stacks;
        return 1.0 + bonus;
    }

    private void resetDecayTimer(final Player player) {
        final UUID uuid = player.getUniqueId();
        this.cancelDecayTimer(uuid);
        BukkitRunnable task = new BukkitRunnable(){

            public void run() {
                int current = playerStacks.getOrDefault(uuid, 0);
                if (current > 0) {
                    playerStacks.put(uuid, current - 1);
                    if (current - 1 > 0) {
                        MomentumSkill.this.resetDecayTimer(player);
                    } else {
                        decayTasks.remove(uuid);
                    }
                }
            }
        };
        task.runTaskLater((Plugin)MetadataHandler.PLUGIN, 80L);
        decayTasks.put(uuid, task);
    }

    private void cancelDecayTimer(UUID uuid) {
        BukkitRunnable task = decayTasks.remove(uuid);
        if (task != null) {
            task.cancel();
        }
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void removeBonus(Player player) {
        activePlayers.remove(player.getUniqueId());
        this.resetStacks(player);
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        this.removeBonus(player);
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        double bonusPerStack = this.getBonusPerStack(skillLevel) * 100.0;
        return List.of("&7Max Stacks: &f8", "&7Damage per Stack: &f+" + String.format("%.1f", bonusPerStack) + "%", "&7Max Bonus: &f+" + String.format("%.1f", bonusPerStack * 8.0) + "%");
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getBonusPerStack(skillLevel) * 8.0;
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("+%.0f%% Max Damage", this.getBonusValue(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        for (BukkitRunnable task : decayTasks.values()) {
            task.cancel();
        }
        decayTasks.clear();
        playerStacks.clear();
        activePlayers.clear();
    }
}

