/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.armor;

import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ProcSkill;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class RetaliationSkill
extends SkillBonus
implements ProcSkill {
    private static final HashSet<UUID> activePlayers = new HashSet();

    public RetaliationSkill() {
        super(SkillType.ARMOR, 25, "Retaliation", "Chance to reflect damage back to attackers", SkillBonusType.PROC, 2, "retaliation");
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
    }

    @Override
    public void removeBonus(Player player) {
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("Chance to reflect damage back to attackers");
        lore.add(String.format("Proc Chance: %.1f%%", this.getProcChance(skillLevel) * 100.0));
        lore.add(String.format("Reflect Damage: %.1f%%", this.getReflectPercent(skillLevel) * 100.0));
        return lore;
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getProcChance(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("%.1f%% chance to reflect %.1f%% damage", this.getProcChance(skillLevel) * 100.0, this.getReflectPercent(skillLevel) * 100.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }

    @Override
    public double getProcChance(int skillLevel) {
        return 0.25;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onProc(Player player, Object context) {
        Object object;
        Object[] params;
        if (context instanceof Object[] && (params = (Object[])context).length >= 2 && (object = params[0]) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)object;
            object = params[1];
            if (object instanceof Double) {
                Double damage = (Double)object;
                int skillLevel = this.getPlayerSkillLevel(player);
                double reflectDamage = damage * this.getReflectPercent(skillLevel);
                EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = true;
                try {
                    attacker.damage(reflectDamage, (Entity)player);
                }
                finally {
                    EliteMobDamagedByPlayerEvent.EliteMobDamagedByPlayerEventFilter.bypass = false;
                }
                player.getWorld().spawnParticle(Particle.CRIT, attacker.getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3, 0.0);
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)String.format("Retaliated %.1f damage!", reflectDamage)));
            }
        }
    }

    private double getReflectPercent(int skillLevel) {
        return 0.3 * this.getScaledValue(skillLevel);
    }

    public void onDamageTaken(Player player, LivingEntity attacker, double damage) {
        if (!this.isActive(player)) {
            return;
        }
        int skillLevel = this.getPlayerSkillLevel(player);
        if (ThreadLocalRandom.current().nextDouble() < this.getProcChance(skillLevel)) {
            this.onProc(player, new Object[]{attacker, damage});
        }
    }

    private int getPlayerSkillLevel(Player player) {
        return SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.ARMOR);
    }
}

