/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.armor;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.CooldownSkill;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class ReactiveShieldingSkill
extends SkillBonus
implements CooldownSkill {
    private static final HashSet<UUID> activePlayers = new HashSet();
    private static final Map<UUID, Long> cooldownMap = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> shieldActiveMap = new HashMap<UUID, Long>();
    private static final long SHIELD_DURATION = 3000L;
    private static final double BIG_HIT_THRESHOLD = 0.2;

    public ReactiveShieldingSkill() {
        super(SkillType.ARMOR, 75, "Reactive Shielding", "Activate damage reduction shield when taking a big hit", SkillBonusType.COOLDOWN, 4, "reactive_shielding");
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
    }

    @Override
    public void removeBonus(Player player) {
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
        cooldownMap.remove(player.getUniqueId());
        shieldActiveMap.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("Activate damage reduction shield when taking a big hit");
        lore.add("Triggers on hits dealing 20%+ of max health");
        lore.add(String.format("Shield Reduction: %.1f%%", this.getShieldReduction(skillLevel) * 100.0));
        lore.add(String.format("Shield Duration: %.1fs", 3.0));
        lore.add(String.format("Cooldown: %ds", this.getCooldownSeconds(skillLevel)));
        return lore;
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getShieldReduction(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("%.1f%% damage reduction shield (CD: %ds)", this.getShieldReduction(skillLevel) * 100.0, this.getCooldownSeconds(skillLevel));
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
        cooldownMap.clear();
        shieldActiveMap.clear();
    }

    @Override
    public long getCooldownSeconds(int skillLevel) {
        return 30L;
    }

    @Override
    public boolean isOnCooldown(Player player) {
        Long cooldownEnd = cooldownMap.get(player.getUniqueId());
        if (cooldownEnd == null) {
            return false;
        }
        if (System.currentTimeMillis() >= cooldownEnd) {
            cooldownMap.remove(player.getUniqueId());
            return false;
        }
        return true;
    }

    @Override
    public void startCooldown(Player player, int skillLevel) {
        long cooldownMs = this.getCooldownSeconds(skillLevel) * 1000L;
        cooldownMap.put(player.getUniqueId(), System.currentTimeMillis() + cooldownMs);
    }

    @Override
    public long getRemainingCooldown(Player player) {
        Long cooldownEnd = cooldownMap.get(player.getUniqueId());
        if (cooldownEnd == null) {
            return 0L;
        }
        long remaining = (cooldownEnd - System.currentTimeMillis()) / 1000L;
        return Math.max(0L, remaining);
    }

    @Override
    public void endCooldown(Player player) {
        cooldownMap.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player, Object event) {
        int skillLevel = this.getPlayerSkillLevel(player);
        shieldActiveMap.put(player.getUniqueId(), System.currentTimeMillis() + 3000L);
        player.getWorld().spawnParticle(Particle.END_ROD, player.getLocation(), 30, 1.0, 1.0, 1.0, 0.05);
        player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 0.5f, 1.5f);
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)"Reactive Shield Activated!"));
        this.startCooldown(player, skillLevel);
    }

    public boolean isShieldActive(Player player) {
        if (!this.isActive(player)) {
            return false;
        }
        Long activeUntil = shieldActiveMap.get(player.getUniqueId());
        if (activeUntil == null) {
            return false;
        }
        if (System.currentTimeMillis() > activeUntil) {
            shieldActiveMap.remove(player.getUniqueId());
            return false;
        }
        return true;
    }

    public void checkTrigger(Player player, double damagePercent) {
        if (!this.isActive(player) || this.isOnCooldown(player)) {
            return;
        }
        if (damagePercent >= 0.2) {
            this.onActivate(player, null);
        }
    }

    public double modifyIncomingDamage(Player player, double originalDamage) {
        if (!this.isShieldActive(player)) {
            return originalDamage;
        }
        int skillLevel = this.getPlayerSkillLevel(player);
        double reduction = this.getShieldReduction(skillLevel);
        return originalDamage * (1.0 - reduction);
    }

    private double getShieldReduction(int skillLevel) {
        return 0.5 + this.getScaledValue(skillLevel) * 0.25;
    }

    private int getPlayerSkillLevel(Player player) {
        return SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.ARMOR);
    }
}

