/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.armor;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;

public class BattleHardenedSkill
extends SkillBonus {
    private static final HashSet<UUID> activePlayers = new HashSet();

    public BattleHardenedSkill() {
        super(SkillType.ARMOR, 10, "Battle Hardened", "Passive damage reduction from all sources", SkillBonusType.PASSIVE, 1, "battle_hardened");
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
    }

    @Override
    public void removeBonus(Player player) {
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("Passive damage reduction from all sources");
        lore.add(String.format("Damage Reduction: %.1f%%", this.getBonusValue(skillLevel) * 15.0));
        return lore;
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getScaledValue(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("%.1f%% Damage Reduction", this.getBonusValue(skillLevel) * 15.0);
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
    }

    public double modifyIncomingDamage(Player player, double originalDamage) {
        if (!this.isActive(player)) {
            return originalDamage;
        }
        int skillLevel = this.getPlayerSkillLevel(player);
        return originalDamage * (1.0 - this.getScaledValue(skillLevel) * 0.15);
    }

    private int getPlayerSkillLevel(Player player) {
        return SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.ARMOR);
    }
}

