/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses.skills.armor;

import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.CooldownSkill;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class AdrenalineSurgeSkill
extends SkillBonus
implements CooldownSkill {
    private static final HashSet<UUID> activePlayers = new HashSet();
    private static final Map<UUID, Long> cooldownMap = new HashMap<UUID, Long>();
    private static final double HEALTH_THRESHOLD = 0.3;

    public AdrenalineSurgeSkill() {
        super(SkillType.ARMOR, 25, "Adrenaline Surge", "Gain buffs when health drops below 30%", SkillBonusType.COOLDOWN, 2, "adrenaline_surge");
    }

    @Override
    public void applyBonus(Player player, int skillLevel) {
    }

    @Override
    public void removeBonus(Player player) {
    }

    @Override
    public void onActivate(Player player) {
        activePlayers.add(player.getUniqueId());
    }

    @Override
    public void onDeactivate(Player player) {
        activePlayers.remove(player.getUniqueId());
        cooldownMap.remove(player.getUniqueId());
    }

    @Override
    public boolean isActive(Player player) {
        return activePlayers.contains(player.getUniqueId());
    }

    @Override
    public List<String> getLoreDescription(int skillLevel) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("Gain buffs when health drops below 30%");
        lore.add(String.format("Buffs: Speed, Strength, Resistance", new Object[0]));
        lore.add(String.format("Duration: %.1fs", (double)this.getDuration(skillLevel) / 20.0));
        lore.add(String.format("Cooldown: %ds", this.getCooldownSeconds(skillLevel)));
        return lore;
    }

    @Override
    public double getBonusValue(int skillLevel) {
        return this.getScaledValue(skillLevel);
    }

    @Override
    public String getFormattedBonus(int skillLevel) {
        return String.format("Buffs on low health (CD: %ds)", this.getCooldownSeconds(skillLevel));
    }

    @Override
    public void shutdown() {
        activePlayers.clear();
        cooldownMap.clear();
    }

    @Override
    public long getCooldownSeconds(int skillLevel) {
        return 45L;
    }

    @Override
    public boolean isOnCooldown(Player player) {
        Long cooldownEnd = cooldownMap.get(player.getUniqueId());
        if (cooldownEnd == null) {
            return false;
        }
        if (System.currentTimeMillis() >= cooldownEnd) {
            cooldownMap.remove(player.getUniqueId());
            return false;
        }
        return true;
    }

    @Override
    public void startCooldown(Player player, int skillLevel) {
        long cooldownMs = this.getCooldownSeconds(skillLevel) * 1000L;
        cooldownMap.put(player.getUniqueId(), System.currentTimeMillis() + cooldownMs);
    }

    @Override
    public long getRemainingCooldown(Player player) {
        Long cooldownEnd = cooldownMap.get(player.getUniqueId());
        if (cooldownEnd == null) {
            return 0L;
        }
        long remaining = (cooldownEnd - System.currentTimeMillis()) / 1000L;
        return Math.max(0L, remaining);
    }

    @Override
    public void endCooldown(Player player) {
        cooldownMap.remove(player.getUniqueId());
    }

    @Override
    public void onActivate(Player player, Object event) {
        int skillLevel = this.getPlayerSkillLevel(player);
        int duration = this.getDuration(skillLevel);
        int amplifier = (int)Math.floor(this.getScaledValue(skillLevel));
        player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, duration, amplifier));
        player.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, duration, amplifier));
        player.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, duration, 0));
        player.getWorld().spawnParticle(Particle.ANGRY_VILLAGER, player.getLocation(), 10, 0.5, 0.5, 0.5, 0.0);
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)"Adrenaline Surge!"));
        this.startCooldown(player, skillLevel);
    }

    public void checkTrigger(Player player, double newHealthPercent) {
        if (!this.isActive(player) || this.isOnCooldown(player)) {
            return;
        }
        if (newHealthPercent <= 0.3) {
            this.onActivate(player, null);
        }
    }

    private int getDuration(int skillLevel) {
        return 100 + (int)(this.getScaledValue(skillLevel) * 40.0);
    }

    private int getPlayerSkillLevel(Player player) {
        return SkillBonusRegistry.getPlayerSkillLevel(player, SkillType.ARMOR);
    }
}

