/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills.bonuses;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.magmacore.util.Logger;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class PlayerSkillSelection {
    public static final int MAX_ACTIVE_SKILLS = 3;
    private static final Gson GSON = new GsonBuilder().create();
    private static final Type SELECTION_TYPE = new TypeToken<Map<String, List<String>>>(){}.getType();
    private static final Map<UUID, Map<SkillType, List<String>>> activeSkills = new HashMap<UUID, Map<SkillType, List<String>>>();

    private PlayerSkillSelection() {
    }

    public static List<String> getActiveSkills(UUID uuid, SkillType skillType) {
        PlayerSkillSelection.ensureLoaded(uuid);
        Map<SkillType, List<String>> playerSkills = activeSkills.get(uuid);
        if (playerSkills == null) {
            return Collections.emptyList();
        }
        return playerSkills.getOrDefault((Object)skillType, Collections.emptyList());
    }

    public static boolean addActiveSkill(UUID uuid, SkillType skillType, String skillId) {
        return PlayerSkillSelection.addActiveSkill(uuid, skillType, skillId, false);
    }

    public static boolean addActiveSkill(UUID uuid, SkillType skillType, String skillId, boolean bypassLimit) {
        PlayerSkillSelection.ensureLoaded(uuid);
        Map playerSkills = activeSkills.computeIfAbsent(uuid, k -> new EnumMap(SkillType.class));
        List typeSkills = playerSkills.computeIfAbsent(skillType, k -> new ArrayList());
        if (!bypassLimit && typeSkills.size() >= 3) {
            return false;
        }
        if (typeSkills.contains(skillId)) {
            return false;
        }
        typeSkills.add(skillId);
        PlayerSkillSelection.saveToDatabase(uuid);
        return true;
    }

    public static boolean removeActiveSkill(UUID uuid, SkillType skillType, String skillId) {
        PlayerSkillSelection.ensureLoaded(uuid);
        Map<SkillType, List<String>> playerSkills = activeSkills.get(uuid);
        if (playerSkills == null) {
            return false;
        }
        List<String> typeSkills = playerSkills.get((Object)skillType);
        if (typeSkills == null) {
            return false;
        }
        boolean removed = typeSkills.remove(skillId);
        if (removed) {
            PlayerSkillSelection.saveToDatabase(uuid);
        }
        return removed;
    }

    public static boolean isSkillActive(UUID uuid, String skillId) {
        PlayerSkillSelection.ensureLoaded(uuid);
        Map<SkillType, List<String>> playerSkills = activeSkills.get(uuid);
        if (playerSkills == null) {
            return false;
        }
        for (List<String> typeSkills : playerSkills.values()) {
            if (!typeSkills.contains(skillId)) continue;
            return true;
        }
        return false;
    }

    public static int getActiveSkillCount(UUID uuid, SkillType skillType) {
        return PlayerSkillSelection.getActiveSkills(uuid, skillType).size();
    }

    public static boolean canAddSkill(UUID uuid, SkillType skillType) {
        return PlayerSkillSelection.getActiveSkillCount(uuid, skillType) < 3;
    }

    public static List<String> getAllActiveSkills(UUID uuid) {
        PlayerSkillSelection.ensureLoaded(uuid);
        ArrayList<String> allSkills = new ArrayList<String>();
        Map<SkillType, List<String>> playerSkills = activeSkills.get(uuid);
        if (playerSkills != null) {
            for (List<String> typeSkills : playerSkills.values()) {
                allSkills.addAll(typeSkills);
            }
        }
        return allSkills;
    }

    public static void clearAllSkills(UUID uuid) {
        activeSkills.remove(uuid);
        PlayerSkillSelection.saveToDatabase(uuid);
    }

    private static void ensureLoaded(UUID uuid) {
        if (!activeSkills.containsKey(uuid)) {
            PlayerSkillSelection.loadFromDatabase(uuid);
        }
    }

    public static void loadFromDatabase(UUID uuid) {
        String json = PlayerData.getSkillBonusSelections(uuid);
        if (json == null || json.isEmpty() || json.equals("{}")) {
            activeSkills.put(uuid, new EnumMap(SkillType.class));
            return;
        }
        try {
            Map parsed = (Map)GSON.fromJson(json, SELECTION_TYPE);
            EnumMap converted = new EnumMap(SkillType.class);
            if (parsed != null) {
                for (Map.Entry entry : parsed.entrySet()) {
                    try {
                        SkillType skillType = SkillType.valueOf((String)entry.getKey());
                        converted.put(skillType, new ArrayList((Collection)entry.getValue()));
                    }
                    catch (IllegalArgumentException e) {
                        Logger.warn("Unknown skill type in database: " + (String)entry.getKey());
                    }
                }
            }
            activeSkills.put(uuid, converted);
        }
        catch (Exception e) {
            Logger.warn("Failed to parse skill selections for player " + String.valueOf(uuid) + ": " + e.getMessage());
            activeSkills.put(uuid, new EnumMap(SkillType.class));
        }
    }

    public static void saveToDatabase(UUID uuid) {
        Map<SkillType, List<String>> playerSkills = activeSkills.get(uuid);
        if (playerSkills == null || playerSkills.isEmpty()) {
            PlayerData.setSkillBonusSelections(uuid, "{}");
            return;
        }
        HashMap<String, List<String>> toSerialize = new HashMap<String, List<String>>();
        for (Map.Entry<SkillType, List<String>> entry : playerSkills.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            toSerialize.put(entry.getKey().name(), entry.getValue());
        }
        String json = GSON.toJson(toSerialize);
        PlayerData.setSkillBonusSelections(uuid, json);
    }

    public static void onPlayerJoin(Player player) {
        PlayerSkillSelection.loadFromDatabase(player.getUniqueId());
    }

    public static void onPlayerLeave(Player player) {
        PlayerSkillSelection.saveToDatabase(player.getUniqueId());
        activeSkills.remove(player.getUniqueId());
    }

    public static void clearCache(UUID uuid) {
        activeSkills.remove(uuid);
    }

    public static void shutdown() {
        for (UUID uuid : new ArrayList<UUID>(activeSkills.keySet())) {
            PlayerSkillSelection.saveToDatabase(uuid);
        }
        activeSkills.clear();
    }
}

