/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills;

import com.magmaguy.elitemobs.antiexploit.FarmingProtection;
import com.magmaguy.elitemobs.api.EliteMobDeathEvent;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.skills.CombatLevelCalculator;
import com.magmaguy.elitemobs.skills.CombatLevelDisplay;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.SkillXPBar;
import com.magmaguy.elitemobs.skills.SkillXPCalculator;
import com.magmaguy.magmacore.util.Logger;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class SkillXPHandler
implements Listener {
    @EventHandler(priority=EventPriority.NORMAL)
    public void onEliteMobDeath(EliteMobDeathEvent event) {
        EliteEntity eliteEntity = event.getEliteEntity();
        if (eliteEntity.isTriggeredAntiExploit()) {
            return;
        }
        if (eliteEntity.getDamagers().isEmpty()) {
            return;
        }
        if (eliteEntity instanceof CustomBossEntity) {
            CustomBossEntity customBoss = (CustomBossEntity)eliteEntity;
            if (!customBoss.getCustomBossesConfigFields().isDropsSkillXP()) {
                return;
            }
            if (!customBoss.getCustomBossesConfigFields().isDropsEliteMobsLoot()) {
                return;
            }
        }
        int mobLevel = eliteEntity.getLevel();
        double totalDamage = eliteEntity.getDamagers().values().stream().mapToDouble(Double::doubleValue).sum();
        if (totalDamage <= 0.0) {
            return;
        }
        for (Map.Entry<Player, Double> entry : eliteEntity.getDamagers().entrySet()) {
            double damagePercent;
            long baseXP;
            long earnedXP;
            Player player = entry.getKey();
            double damageDealt = entry.getValue();
            if (player.hasMetadata("NPC") || !PlayerData.isInMemory(player.getUniqueId()) || !(eliteEntity instanceof CustomBossEntity) && !FarmingProtection.recordNaturalEliteKill(player, eliteEntity)) continue;
            int effectiveMobLevel = FarmingProtection.getEffectiveMobLevelForXP(player, mobLevel);
            double xpMultiplier = FarmingProtection.getXPMultiplier(player, mobLevel);
            if (xpMultiplier <= 0.0) {
                this.notifyLevelDifferenceLimit(player, mobLevel, true);
                continue;
            }
            if (effectiveMobLevel < mobLevel) {
                this.notifyLevelDifferenceLimit(player, mobLevel, false);
            }
            if ((earnedXP = (long)((double)(baseXP = SkillXPCalculator.calculateMobXP(effectiveMobLevel)) * (damagePercent = damageDealt / totalDamage))) <= 0L) continue;
            this.awardWeaponXP(player, earnedXP);
            this.awardArmorXP(player, earnedXP);
        }
    }

    private void awardWeaponXP(Player player, long baseXP) {
        Material weaponMaterial = player.getInventory().getItemInMainHand().getType();
        SkillType skillType = SkillType.fromMaterial(weaponMaterial);
        if (skillType == null) {
            return;
        }
        long oldXP = PlayerData.getSkillXP(player.getUniqueId(), skillType);
        int previousLevel = SkillXPCalculator.levelFromTotalXP(oldXP);
        long xpToAdd = SkillXPCalculator.applySkillMultiplier(skillType, baseXP);
        long newXP = PlayerData.addSkillXP(player.getUniqueId(), skillType, xpToAdd);
        SkillXPBar.showXPGain(player, skillType, oldXP, newXP, xpToAdd);
        int newLevel = SkillXPCalculator.levelFromTotalXP(newXP);
        if (newLevel > previousLevel) {
            this.notifyLevelUp(player, skillType, newLevel);
        }
    }

    private void awardArmorXP(Player player, long baseXP) {
        long oldXP = PlayerData.getSkillXP(player.getUniqueId(), SkillType.ARMOR);
        int previousLevel = SkillXPCalculator.levelFromTotalXP(oldXP);
        long armorXP = SkillXPCalculator.applySkillMultiplier(SkillType.ARMOR, baseXP);
        long newXP = PlayerData.addSkillXP(player.getUniqueId(), SkillType.ARMOR, armorXP);
        SkillXPBar.showXPGain(player, SkillType.ARMOR, oldXP, newXP, armorXP);
        int newLevel = SkillXPCalculator.levelFromTotalXP(newXP);
        if (newLevel > previousLevel) {
            this.notifyLevelUp(player, SkillType.ARMOR, newLevel);
        }
    }

    private void notifyLevelUp(Player player, SkillType skillType, int newLevel) {
        String message = "&a&lSKILL UP! &r&a" + skillType.getDisplayName() + " &7is now level &e" + newLevel;
        player.sendMessage(message.replace("&", "\u00a7"));
        if (newLevel % 10 == 0) {
            player.sendTitle("\u00a7a\u00a7l" + skillType.getDisplayName() + " Level " + newLevel, "\u00a77Congratulations!", 10, 70, 20);
        }
        CombatLevelDisplay.updateDisplay(player);
        Logger.debug("Player " + player.getName() + " reached " + skillType.getDisplayName() + " level " + newLevel);
    }

    private void notifyLevelDifferenceLimit(Player player, int mobLevel, boolean noXP) {
        String message;
        int combatLevel = CombatLevelCalculator.calculateCombatLevel(player.getUniqueId());
        if (noXP) {
            int levelDiff = combatLevel - mobLevel;
            message = "&7[&eEliteMobs&7] &cNo XP gained &7- this mob (level &f" + mobLevel + "&7) is &f" + levelDiff + " levels &7below your combat level (&f" + combatLevel + "&7).";
        } else {
            int cappedLevel = combatLevel + 5;
            message = "&7[&eEliteMobs&7] &6XP capped &7- this mob (level &f" + mobLevel + "&7) is too high. XP calculated as if level &f" + cappedLevel + "&7.";
        }
        player.sendMessage(message.replace("&", "\u00a7"));
    }
}

