/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.SkillsConfig;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.SkillXPCalculator;
import com.magmaguy.magmacore.util.ChatColorConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class SkillXPBar
implements Listener {
    private static final int DISPLAY_DURATION_TICKS = 100;
    private static final int ANIMATION_TICKS = 20;
    private static final Map<UUID, Map<SkillType, SkillBarData>> playerBars = new HashMap<UUID, Map<SkillType, SkillBarData>>();

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        SkillXPBar.removeAllBars(event.getPlayer());
    }

    public static void showXPGain(Player player, SkillType skillType, long oldXP, long newXP, long xpGained) {
        boolean leveledUp;
        if (!SkillsConfig.isSkillSystemEnabled()) {
            return;
        }
        if (!SkillsConfig.isShowXPBar()) {
            return;
        }
        UUID uuid = player.getUniqueId();
        playerBars.computeIfAbsent(uuid, k -> new HashMap());
        Map<SkillType, SkillBarData> skillBars = playerBars.get(uuid);
        SkillBarData barData = skillBars.get((Object)skillType);
        int oldLevel = SkillXPCalculator.levelFromTotalXP(oldXP);
        int newLevel = SkillXPCalculator.levelFromTotalXP(newXP);
        boolean bl = leveledUp = newLevel > oldLevel;
        if (barData == null || !barData.isValid()) {
            barData = new SkillBarData(player, skillType);
            skillBars.put(skillType, barData);
        }
        barData.updateProgress(oldXP, newXP, xpGained, leveledUp, newLevel);
    }

    public static void removeAllBars(Player player) {
        Map<SkillType, SkillBarData> skillBars = playerBars.remove(player.getUniqueId());
        if (skillBars != null) {
            skillBars.values().forEach(SkillBarData::destroy);
        }
    }

    public static void shutdown() {
        for (Map<SkillType, SkillBarData> skillBars : playerBars.values()) {
            skillBars.values().forEach(SkillBarData::destroy);
        }
        playerBars.clear();
    }

    private static class SkillBarData {
        private final UUID playerUUID;
        private final SkillType skillType;
        private final BossBar bossBar;
        private BukkitTask animationTask;
        private BukkitTask hideTask;
        private double currentDisplayProgress;
        private double targetProgress;
        private int displayLevel;

        SkillBarData(Player player, SkillType skillType) {
            this.playerUUID = player.getUniqueId();
            this.skillType = skillType;
            this.bossBar = Bukkit.createBossBar((String)SkillBarData.getBarTitle(skillType, 1, 0L), (BarColor)SkillBarData.getBarColor(skillType), (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            this.bossBar.addPlayer(player);
            this.bossBar.setVisible(true);
            this.currentDisplayProgress = 0.0;
            this.targetProgress = 0.0;
            this.displayLevel = 1;
        }

        private Player getPlayer() {
            return Bukkit.getPlayer((UUID)this.playerUUID);
        }

        boolean isValid() {
            Player player = this.getPlayer();
            return this.bossBar != null && player != null && player.isOnline();
        }

        void updateProgress(long oldXP, long newXP, long xpGained, boolean leveledUp, int newLevel) {
            Player player = this.getPlayer();
            if (player == null || !player.isOnline()) {
                return;
            }
            if (this.animationTask != null) {
                this.animationTask.cancel();
                this.animationTask = null;
            }
            if (this.hideTask != null) {
                this.hideTask.cancel();
                this.hideTask = null;
            }
            this.bossBar.removeAll();
            this.bossBar.addPlayer(player);
            this.bossBar.setVisible(true);
            double oldProgress = SkillXPCalculator.levelProgress(oldXP);
            double newProgress = SkillXPCalculator.levelProgress(newXP);
            if (leveledUp) {
                this.animateLevelUp(oldProgress, newProgress, newLevel, xpGained);
            } else {
                this.displayLevel = newLevel;
                this.currentDisplayProgress = oldProgress;
                this.targetProgress = newProgress;
                this.animateProgress(xpGained);
            }
            this.scheduleHide();
        }

        private void animateLevelUp(double oldProgress, final double newProgress, final int newLevel, final long xpGained) {
            int oldLevel;
            this.displayLevel = oldLevel = newLevel - 1;
            this.currentDisplayProgress = oldProgress;
            this.animationTask = new BukkitRunnable(){
                int tick = 0;
                boolean filledBar = false;
                boolean showedLevelUp = false;

                public void run() {
                    Player player = this.getPlayer();
                    if (player == null || !player.isOnline()) {
                        this.cancel();
                        return;
                    }
                    if (!this.filledBar) {
                        double progress = currentDisplayProgress + (1.0 - currentDisplayProgress) * ((double)this.tick / 10.0);
                        progress = Math.min(1.0, progress);
                        bossBar.setProgress(progress);
                        bossBar.setTitle(SkillBarData.getBarTitle(skillType, displayLevel, xpGained));
                        if (this.tick >= 10) {
                            this.filledBar = true;
                            this.tick = 0;
                        }
                    } else if (!this.showedLevelUp) {
                        displayLevel = newLevel;
                        this.playLevelUpEffects();
                        bossBar.setProgress(0.0);
                        bossBar.setTitle(SkillBarData.getLevelUpTitle(skillType, newLevel));
                        bossBar.setColor(BarColor.YELLOW);
                        this.showedLevelUp = true;
                        this.tick = 0;
                    } else {
                        double progress = newProgress * ((double)this.tick / 20.0);
                        progress = Math.min(newProgress, progress);
                        bossBar.setProgress(progress);
                        bossBar.setColor(SkillBarData.getBarColor(skillType));
                        bossBar.setTitle(SkillBarData.getBarTitle(skillType, newLevel, xpGained));
                        if (this.tick >= 20) {
                            bossBar.setProgress(newProgress);
                            currentDisplayProgress = newProgress;
                            this.cancel();
                            return;
                        }
                    }
                    ++this.tick;
                }
            }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
        }

        private void animateProgress(final long xpGained) {
            final double startProgress = this.currentDisplayProgress;
            final double endProgress = this.targetProgress;
            this.animationTask = new BukkitRunnable(){
                int tick = 0;

                public void run() {
                    Player player = this.getPlayer();
                    if (player == null || !player.isOnline()) {
                        this.cancel();
                        return;
                    }
                    double progress = startProgress + (endProgress - startProgress) * ((double)this.tick / 20.0);
                    progress = Math.min(Math.max(0.0, progress), 1.0);
                    bossBar.setProgress(progress);
                    bossBar.setTitle(SkillBarData.getBarTitle(skillType, displayLevel, xpGained));
                    if (this.tick >= 20) {
                        bossBar.setProgress(endProgress);
                        currentDisplayProgress = endProgress;
                        this.cancel();
                        return;
                    }
                    ++this.tick;
                }
            }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
        }

        private void playLevelUpEffects() {
            Player player = this.getPlayer();
            if (player == null || !player.isOnline()) {
                return;
            }
            player.playSound(player.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.2f);
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
            new BukkitRunnable(){
                int tick = 0;
                double angle = 0.0;

                public void run() {
                    Player p = this.getPlayer();
                    if (p == null || !p.isOnline() || this.tick > 20) {
                        this.cancel();
                        return;
                    }
                    for (int i = 0; i < 3; ++i) {
                        double x = Math.cos(this.angle + (double)i * 2.094) * 1.0;
                        double z = Math.sin(this.angle + (double)i * 2.094) * 1.0;
                        double y = (double)this.tick * 0.1;
                        p.getWorld().spawnParticle(Particle.TOTEM_OF_UNDYING, p.getLocation().add(x, y + 0.5, z), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    if (this.tick % 5 == 0) {
                        p.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, p.getLocation().add(0.0, 1.0 + (double)this.tick * 0.05, 0.0), 10, 0.5, 0.3, 0.5, 0.0);
                    }
                    this.angle += 0.5;
                    ++this.tick;
                }
            }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
        }

        private void scheduleHide() {
            this.hideTask = new BukkitRunnable(){

                public void run() {
                    if (bossBar != null) {
                        bossBar.setVisible(false);
                    }
                }
            }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 100L);
        }

        void destroy() {
            if (this.animationTask != null) {
                this.animationTask.cancel();
            }
            if (this.hideTask != null) {
                this.hideTask.cancel();
            }
            if (this.bossBar != null) {
                this.bossBar.removeAll();
            }
        }

        private static String getBarTitle(SkillType skillType, int level, long xpGained) {
            String xpText = xpGained > 0L ? " &a(+" + SkillBarData.formatNumber(xpGained) + " XP)" : "";
            return ChatColorConverter.convert("&6" + skillType.getDisplayName() + " &7Lv." + level + xpText);
        }

        private static String getLevelUpTitle(SkillType skillType, int newLevel) {
            return ChatColorConverter.convert("&e&l\u2726 " + skillType.getDisplayName() + " LEVEL UP! &7\u2192 &eLv." + newLevel + " &e&l\u2726");
        }

        private static BarColor getBarColor(SkillType skillType) {
            return switch (skillType) {
                default -> throw new MatchException(null, null);
                case SkillType.ARMOR -> BarColor.BLUE;
                case SkillType.SWORDS -> BarColor.RED;
                case SkillType.AXES -> BarColor.RED;
                case SkillType.BOWS -> BarColor.GREEN;
                case SkillType.CROSSBOWS -> BarColor.GREEN;
                case SkillType.TRIDENTS -> BarColor.BLUE;
                case SkillType.HOES -> BarColor.PURPLE;
            };
        }

        private static String formatNumber(long number) {
            if (number >= 1000000L) {
                return String.format("%.1fM", (double)number / 1000000.0);
            }
            if (number >= 1000L) {
                return String.format("%.1fK", (double)number / 1000.0);
            }
            return String.valueOf(number);
        }
    }
}

