/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.SkillsConfig;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.skills.CombatLevelCalculator;
import com.magmaguy.magmacore.util.ChatColorConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;
import org.joml.Vector3f;

public class CombatLevelDisplay
implements Listener {
    private static final Map<UUID, TextDisplay> playerDisplays = new HashMap<UUID, TextDisplay>();

    public static void createDisplay(Player player) {
        if (!SkillsConfig.isSkillSystemEnabled()) {
            return;
        }
        if (!SkillsConfig.isShowCombatLevelDisplay()) {
            return;
        }
        CombatLevelDisplay.removeDisplay(player);
        TextDisplay display = (TextDisplay)player.getWorld().spawn(player.getLocation(), TextDisplay.class, textDisplay -> {
            textDisplay.setText(ChatColorConverter.convert(CombatLevelCalculator.getFormattedCombatLevel(player.getUniqueId())));
            textDisplay.setPersistent(false);
            textDisplay.setInterpolationDelay(0);
            textDisplay.setInterpolationDuration(0);
            textDisplay.setBillboard(Display.Billboard.CENTER);
            textDisplay.setShadowed(true);
            textDisplay.setSeeThrough(false);
            Transformation transformation = textDisplay.getTransformation();
            textDisplay.setTransformation(new Transformation(new Vector3f(0.0f, 0.7f, 0.0f), transformation.getLeftRotation(), transformation.getScale(), transformation.getRightRotation()));
        });
        EntityTracker.registerVisualEffects((Entity)display);
        player.addPassenger((Entity)display);
        playerDisplays.put(player.getUniqueId(), display);
    }

    public static void removeDisplay(Player player) {
        TextDisplay display = playerDisplays.remove(player.getUniqueId());
        if (display != null && display.isValid()) {
            player.removePassenger((Entity)display);
            display.remove();
        }
    }

    public static void updateDisplay(Player player) {
        TextDisplay display = playerDisplays.get(player.getUniqueId());
        if (display != null && display.isValid()) {
            display.setText(ChatColorConverter.convert(CombatLevelCalculator.getFormattedCombatLevel(player.getUniqueId())));
        } else {
            CombatLevelDisplay.createDisplay(player);
        }
    }

    public static void updateDisplay(UUID playerUUID) {
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player != null && player.isOnline()) {
            CombatLevelDisplay.updateDisplay(player);
        }
    }

    public static void shutdown() {
        for (Map.Entry<UUID, TextDisplay> entry : playerDisplays.entrySet()) {
            TextDisplay display = entry.getValue();
            if (display == null || !display.isValid()) continue;
            display.remove();
        }
        playerDisplays.clear();
    }

    public static void initialize() {
        if (!SkillsConfig.isSkillSystemEnabled()) {
            return;
        }
        if (!SkillsConfig.isShowCombatLevelDisplay()) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    CombatLevelDisplay.createDisplay(player);
                }
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 20L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(final PlayerJoinEvent event) {
        if (!SkillsConfig.isSkillSystemEnabled()) {
            return;
        }
        if (!SkillsConfig.isShowCombatLevelDisplay()) {
            return;
        }
        new BukkitRunnable(this){

            public void run() {
                if (event.getPlayer().isOnline()) {
                    CombatLevelDisplay.createDisplay(event.getPlayer());
                }
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 40L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        CombatLevelDisplay.removeDisplay(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerRespawn(final PlayerRespawnEvent event) {
        if (!SkillsConfig.isSkillSystemEnabled()) {
            return;
        }
        if (!SkillsConfig.isShowCombatLevelDisplay()) {
            return;
        }
        new BukkitRunnable(this){

            public void run() {
                if (event.getPlayer().isOnline()) {
                    CombatLevelDisplay.createDisplay(event.getPlayer());
                }
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 5L);
    }
}

