/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills;

import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.SkillXPCalculator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;

public class CombatLevelCalculator {
    private CombatLevelCalculator() {
    }

    public static int calculateCombatLevel(UUID playerUUID) {
        ArrayList<Integer> weaponLevels = new ArrayList<Integer>();
        for (SkillType skillType : SkillType.values()) {
            if (skillType == SkillType.ARMOR) continue;
            long xp = PlayerData.getSkillXP(playerUUID, skillType);
            int level = SkillXPCalculator.levelFromTotalXP(xp);
            weaponLevels.add(level);
        }
        Collections.sort(weaponLevels, Collections.reverseOrder());
        int highestWeapon = weaponLevels.size() > 0 ? (Integer)weaponLevels.get(0) : 1;
        int secondHighestWeapon = weaponLevels.size() > 1 ? (Integer)weaponLevels.get(1) : 1;
        long armorXP = PlayerData.getSkillXP(playerUUID, SkillType.ARMOR);
        int armorLevel = SkillXPCalculator.levelFromTotalXP(armorXP);
        return (highestWeapon + secondHighestWeapon + armorLevel) / 3;
    }

    public static String getFormattedCombatLevel(UUID playerUUID) {
        int combatLevel = CombatLevelCalculator.calculateCombatLevel(playerUUID);
        return "\u00a76\u00a7lCombat Lv. " + combatLevel;
    }
}

