/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.quests.rewards;

import com.magmaguy.elitemobs.economy.EconomyHandler;
import com.magmaguy.elitemobs.utils.ObjectSerializer;
import com.magmaguy.magmacore.util.Logger;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RewardEntry
implements Serializable {
    private final double chance;
    private final int amount;
    private byte[] deserializedCustomItem;
    private transient ItemStack itemStack;
    private String deserializedItemStack;
    private String command;
    private double currencyAmount = 0.0;

    public RewardEntry(ItemStack itemStack, double chance, int amount) {
        this.itemStack = itemStack;
        try {
            this.deserializedItemStack = ObjectSerializer.itemStackArrayToBase64(itemStack);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.chance = chance;
        this.amount = amount;
    }

    public RewardEntry(String command, double chance, int amount) {
        this.command = command;
        this.chance = chance;
        this.amount = amount;
    }

    public RewardEntry(double currencyAmount, double chance, int amount, Player player) {
        this.currencyAmount = currencyAmount;
        this.chance = chance;
        this.amount = amount;
    }

    public void serializeReward() {
        if (this.itemStack == null && this.deserializedItemStack != null) {
            try {
                this.itemStack = ObjectSerializer.itemStackArrayFromBase64(this.deserializedItemStack);
            }
            catch (Exception ex) {
                Logger.warn("Failed to serialize item stack");
                ex.printStackTrace();
            }
        }
    }

    public void doReward(UUID playerUUID) {
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (ThreadLocalRandom.current().nextDouble() < this.chance) {
            for (int i = 0; i < this.amount; ++i) {
                if (this.itemStack != null) {
                    player.getInventory().addItem(new ItemStack[]{this.itemStack});
                    continue;
                }
                if (this.command != null) {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.command.replace("$player", player.getName()));
                    continue;
                }
                if (this.currencyAmount != 0.0) {
                    EconomyHandler.addCurrency(playerUUID, this.currencyAmount);
                    continue;
                }
                Logger.warn("Quest failed to dispatch reward! Report this to the dev!", true);
            }
        }
    }

    @Generated
    public double getChance() {
        return this.chance;
    }

    @Generated
    public int getAmount() {
        return this.amount;
    }

    @Generated
    public byte[] getDeserializedCustomItem() {
        return this.deserializedCustomItem;
    }

    @Generated
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Generated
    public String getDeserializedItemStack() {
        return this.deserializedItemStack;
    }

    @Generated
    public String getCommand() {
        return this.command;
    }

    @Generated
    public double getCurrencyAmount() {
        return this.currencyAmount;
    }
}

