/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.quests.rewards;

import com.magmaguy.elitemobs.config.customquests.CustomQuestsConfigFields;
import com.magmaguy.elitemobs.items.LootTables;
import com.magmaguy.elitemobs.items.customloottable.CustomLootTable;
import com.magmaguy.elitemobs.quests.objectives.Objective;
import com.magmaguy.elitemobs.quests.objectives.QuestObjectives;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class QuestReward
implements Serializable {
    private final int rewardLevel;
    private final UUID playerUUID;
    private CustomLootTable customLootTable = null;

    public QuestReward(int questLevel, QuestObjectives questObjectives, Player player) {
        this.rewardLevel = questLevel * 10;
        this.playerUUID = player.getUniqueId();
        int killAmount = questObjectives.getObjectives().stream().mapToInt(Objective::getTargetAmount).sum();
        int baselineReward = (int)((double)this.rewardLevel / 2.0 * (double)killAmount);
        this.customLootTable = new CustomLootTable();
        this.customLootTable.generateCurrencyEntry(baselineReward);
        ItemStack itemReward = LootTables.generateItemStack(this.rewardLevel, player, null);
        this.customLootTable.generateEliteEntry(itemReward);
    }

    public QuestReward(CustomQuestsConfigFields customQuestsConfigFields, Player player) {
        this.rewardLevel = customQuestsConfigFields.getQuestLevel() * 10;
        this.playerUUID = player.getUniqueId();
        this.customLootTable = new CustomLootTable(customQuestsConfigFields);
    }

    public void doRewards() {
        this.customLootTable.questDrop(Bukkit.getPlayer((UUID)this.playerUUID), this.rewardLevel);
    }

    public List<ItemStack> previewRewards() {
        return this.customLootTable.previewQuestDrop(Bukkit.getPlayer((UUID)this.playerUUID), this.rewardLevel);
    }

    @Generated
    public int getRewardLevel() {
        return this.rewardLevel;
    }

    @Generated
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    @Generated
    public CustomLootTable getCustomLootTable() {
        return this.customLootTable;
    }
}

