/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.quests.menus;

import com.magmaguy.elitemobs.commands.quests.QuestCommand;
import com.magmaguy.elitemobs.config.QuestsConfig;
import com.magmaguy.elitemobs.npcs.NPCEntity;
import com.magmaguy.elitemobs.quests.CustomQuest;
import com.magmaguy.elitemobs.quests.Quest;
import com.magmaguy.elitemobs.quests.menus.QuestMenu;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class QuestInventoryMenu {
    private static final int trackEntry = 8;
    private static final int acceptEntry = 26;
    private static final HashMap<Inventory, QuestDirectory> questDirectories = new HashMap();
    private static final HashMap<Inventory, QuestInventory> questInventories = new HashMap();

    public static void shutdown() {
        questDirectories.clear();
        questInventories.clear();
    }

    private QuestInventoryMenu() {
    }

    public static void generateInventoryQuestEntries(List<? extends Quest> quests, Player player, NPCEntity npcEntity) {
        if (quests.size() == 1) {
            QuestInventoryMenu.generateInventoryQuestEntry(quests.get(0), player, npcEntity);
        } else {
            QuestInventoryMenu.generateInventoryQuestDirectory(quests, player, npcEntity);
        }
    }

    public static void generateInventoryQuestDirectory(List<? extends Quest> quests, Player player, NPCEntity npcEntity) {
        String menuTitle = "Quests";
        Inventory questInventory = Bukkit.createInventory((InventoryHolder)player, (int)27, (String)menuTitle);
        ArrayList<Integer> questSlots = new ArrayList<Integer>(new ArrayList<Integer>(List.of(Integer.valueOf(13), Integer.valueOf(11), Integer.valueOf(15), Integer.valueOf(9), Integer.valueOf(17), Integer.valueOf(10), Integer.valueOf(16), Integer.valueOf(12), Integer.valueOf(14), Integer.valueOf(8))));
        Material acceptMaterial = Material.GREEN_STAINED_GLASS_PANE;
        Material inProgressMaterial = Material.RED_STAINED_GLASS_PANE;
        Material completeMaterial = Material.ORANGE_STAINED_GLASS_PANE;
        HashMap<Integer, Quest> questMap = new HashMap<Integer, Quest>();
        for (int i = 0; i < quests.size() && i <= 10; ++i) {
            questMap.put((Integer)questSlots.get(i), quests.get(i));
            QuestMenu.QuestText questText = new QuestMenu.QuestText(quests.get(i), npcEntity, player);
            if (!quests.get(i).isAccepted()) {
                questInventory.setItem(((Integer)questSlots.get(i)).intValue(), ItemStackGenerator.generateItemStack(acceptMaterial, questText.getHeader().getText()));
                continue;
            }
            if (!quests.get(i).getQuestObjectives().isOver()) {
                questInventory.setItem(((Integer)questSlots.get(i)).intValue(), ItemStackGenerator.generateItemStack(inProgressMaterial, questText.getHeader().getText()));
                continue;
            }
            questInventory.setItem(((Integer)questSlots.get(i)).intValue(), ItemStackGenerator.generateItemStack(completeMaterial, questText.getHeader().getText()));
        }
        new QuestDirectory(player, questMap, questInventory, npcEntity);
        player.openInventory(questInventory);
    }

    public static void generateInventoryQuestEntry(Quest quest, Player player, NPCEntity npcEntity) {
        QuestMenu.QuestText questText = new QuestMenu.QuestText(quest, npcEntity, player);
        String title = "";
        if (questText.getHeader().getText() != null) {
            title = questText.getHeader().getText();
        }
        Inventory questInventory = Bukkit.createInventory((InventoryHolder)player, (int)27, (String)title);
        int titleEntry = 4;
        ArrayList<Integer> loreEntries = new ArrayList<Integer>(new ArrayList<Integer>(List.of(Integer.valueOf(13), Integer.valueOf(14), Integer.valueOf(12), Integer.valueOf(15), Integer.valueOf(11), Integer.valueOf(16), Integer.valueOf(10), Integer.valueOf(17), Integer.valueOf(9))));
        ArrayList<Integer> objectivesEntries = new ArrayList<Integer>(new ArrayList<Integer>(List.of(Integer.valueOf(21), Integer.valueOf(20), Integer.valueOf(19), Integer.valueOf(18))));
        ArrayList<Integer> rewardEntries = new ArrayList<Integer>(new ArrayList<Integer>(List.of(Integer.valueOf(23), Integer.valueOf(24), Integer.valueOf(25))));
        Material titleMaterial = Material.PAINTING;
        Material trackingMaterial = Material.TARGET;
        Material loreMaterial = Material.BOOK;
        Material objectivesMaterial = Material.ITEM_FRAME;
        Material rewardsMaterial = Material.GOLD_INGOT;
        Material acceptMaterial = Material.EMERALD;
        questInventory.setItem(titleEntry, QuestInventoryMenu.generateItemStackEntry(questText.getHeader(), new TextComponent(), titleMaterial).get(0));
        if (quest instanceof CustomQuest && quest.isAccepted()) {
            questInventory.setItem(8, QuestInventoryMenu.generateItemStackEntry(questText.getTrack(), new TextComponent(), trackingMaterial).get(0));
        }
        questInventory.setItem(26, QuestInventoryMenu.generateItemStackEntry(questText.getAccept(), new TextComponent(), acceptMaterial).get(0));
        if (quest instanceof CustomQuest) {
            QuestInventoryMenu.fillItemSlotLists(questInventory, loreEntries, new TextComponent(" "), questText.getBody(), loreMaterial);
        }
        QuestInventoryMenu.fillItemSlotLists(questInventory, objectivesEntries, questText.getFixedSummary(), questText.getSummary(), objectivesMaterial);
        QuestInventoryMenu.fillItemSlotLists(questInventory, rewardEntries, questText.getFixedRewards(), questText.getRewards(), rewardsMaterial);
        new QuestInventory(player, quest, questInventory, npcEntity);
        player.openInventory(questInventory);
    }

    public static void fillItemSlotLists(Inventory inventory, List<Integer> entries, TextComponent title, List<TextComponent> textComponents, Material material) {
        List<ItemStack> loreItems = QuestInventoryMenu.generateItemStackEntry(title, textComponents, material);
        List<Integer> exactEntriesAmount = new ArrayList<Integer>(entries);
        exactEntriesAmount = exactEntriesAmount.subList(0, loreItems.size());
        Collections.sort(exactEntriesAmount);
        for (int i = 0; i < exactEntriesAmount.size(); ++i) {
            inventory.setItem(exactEntriesAmount.get(i).intValue(), loreItems.get(i));
        }
    }

    public static List<ItemStack> generateItemStackEntry(TextComponent title, List<TextComponent> textComponents, Material material) {
        ArrayList<String> list = new ArrayList<String>();
        textComponents.forEach(component -> {
            if (component.getText().length() < 27) {
                list.add(String.valueOf(ChatColor.WHITE) + component.getText().replace(String.valueOf(ChatColor.BLACK), String.valueOf(ChatColor.WHITE)));
            } else {
                ChatColor currentColor = ChatColor.WHITE;
                int i = 0;
                while ((double)i < (double)component.getText().length() / 26.0) {
                    String string = String.valueOf(currentColor) + ChatColorConverter.convert(component.getText().substring(i * 26, Math.min((i + 1) * 26, component.getText().length())).replace(String.valueOf(ChatColor.BLACK), String.valueOf(ChatColor.WHITE)));
                    list.add(string);
                    String lastColor = ChatColor.getLastColors((String)string);
                    if (!lastColor.isEmpty()) {
                        currentColor = ChatColor.getByChar((String)lastColor);
                    }
                    if (currentColor == null) {
                        currentColor = ChatColor.WHITE;
                    }
                    ++i;
                }
            }
        });
        return QuestInventoryMenu.generateParsedItemStackEntry(title.getText(), list, material);
    }

    public static List<ItemStack> generateItemStackEntry(TextComponent title, TextComponent textComponent, Material material) {
        return QuestInventoryMenu.generateParsedItemStackEntry(title.getText(), Collections.singletonList(textComponent.getText()), material);
    }

    public static List<ItemStack> generateParsedItemStackEntry(String title, List<String> rawLore, Material material) {
        title = title.replace(ChatColor.BLACK.toString(), ChatColor.WHITE.toString());
        ArrayList<String> lore = new ArrayList<String>();
        rawLore.forEach(raw -> lore.add(String.valueOf(ChatColor.WHITE) + raw.replace(ChatColor.BLACK.toString(), ChatColor.WHITE.toString())));
        int characterLimit = QuestsConfig.getItemEntryCharacterLimitBedrockMenu();
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        AtomicInteger counter = new AtomicInteger();
        lore.forEach(entry -> counter.addAndGet(entry.length()));
        if (counter.get() < characterLimit) {
            itemStacks.add(ItemStackGenerator.generateItemStack(material, title, lore));
            return itemStacks;
        }
        int maxCharactersPerLine = QuestsConfig.getHorizontalCharacterLimitBedrockMenu();
        ArrayList<String> currentList = new ArrayList<String>();
        int currentCharacterCount = 0;
        for (String entry2 : lore) {
            entry2 = entry2.replace(ChatColor.BLACK.toString(), ChatColor.WHITE.toString());
            if (!currentList.isEmpty() && entry2.length() + currentCharacterCount > characterLimit) {
                itemStacks.add(ItemStackGenerator.generateItemStack(material, title, currentList));
                currentList.clear();
                currentCharacterCount = 0;
            }
            if (entry2.length() > maxCharactersPerLine) {
                int size = 30;
                if (!entry2.contains(" ")) {
                    ArrayList<CallSite> substrings = new ArrayList<CallSite>((entry2.length() + size - 1) / size);
                    for (int start = 0; start < entry2.length(); start += size) {
                        substrings.add((CallSite)((Object)(String.valueOf(ChatColor.WHITE) + entry2.substring(start, Math.min(entry2.length(), start + size)))));
                    }
                    currentList.addAll(substrings);
                } else {
                    String[] splitBySpaces = entry2.split(" ");
                    ArrayList<String> substrings = new ArrayList<String>();
                    StringBuilder currentString = new StringBuilder();
                    currentString.append(ChatColor.WHITE);
                    for (String string : splitBySpaces) {
                        String string2 = string + " ";
                        if (currentString.length() + string2.length() > size) {
                            substrings.add(currentString.toString());
                            currentString = new StringBuilder();
                            currentString.append(ChatColor.WHITE);
                        }
                        currentString.append(string2);
                    }
                    substrings.add(currentString.toString());
                    currentList.addAll(substrings);
                }
            } else {
                currentList.add(entry2);
            }
            currentCharacterCount += entry2.length();
        }
        itemStacks.add(ItemStackGenerator.generateItemStack(material, title, currentList));
        return itemStacks;
    }

    private static class QuestDirectory {
        HashMap<Integer, Quest> questMap;
        Inventory inventory;
        NPCEntity npcEntity;
        Player player;

        private QuestDirectory(Player player, HashMap<Integer, Quest> questMap, Inventory inventory, NPCEntity npcEntity) {
            this.questMap = questMap;
            this.inventory = inventory;
            this.npcEntity = npcEntity;
            this.player = player;
            questDirectories.put(inventory, this);
        }
    }

    private static class QuestInventory {
        Quest quest;
        Inventory inventory;
        NPCEntity npcEntity;
        Player player;

        private QuestInventory(Player player, Quest quest, Inventory inventory, NPCEntity npcEntity) {
            this.quest = quest;
            this.inventory = inventory;
            this.npcEntity = npcEntity;
            this.player = player;
            questInventories.put(inventory, this);
        }
    }

    public static class QuestInventoryMenuEvents
    implements Listener {
        @EventHandler(priority=EventPriority.HIGHEST)
        public void onInventoryInteract(InventoryClickEvent event) {
            Player player = ((Player)event.getWhoClicked()).getPlayer();
            if (questDirectories.containsKey(event.getInventory())) {
                event.setCancelled(true);
                QuestDirectory questDirectory = questDirectories.get(event.getInventory());
                if (questDirectory.questMap.get(event.getSlot()) == null) {
                    return;
                }
                player.closeInventory();
                QuestInventoryMenu.generateInventoryQuestEntry(questDirectory.questMap.get(event.getSlot()), questDirectory.player, questDirectory.npcEntity);
            } else if (questInventories.containsKey(event.getInventory())) {
                event.setCancelled(true);
                switch (event.getSlot()) {
                    case 8: {
                        QuestCommand.trackQuest(QuestInventoryMenu.questInventories.get((Object)event.getInventory()).quest.getQuestID().toString(), player);
                        player.closeInventory();
                        break;
                    }
                    case 26: {
                        Quest quest = QuestInventoryMenu.questInventories.get((Object)event.getInventory()).quest;
                        if (!quest.isAccepted()) {
                            QuestCommand.joinQuest(quest.getQuestID().toString(), player);
                        } else if (!quest.getQuestObjectives().isOver()) {
                            QuestCommand.leaveQuest(player, quest.getQuestID().toString());
                        } else {
                            QuestCommand.completeQuest(quest.getQuestID().toString(), player);
                        }
                        player.closeInventory();
                    }
                }
            }
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void onInventoryClose(InventoryCloseEvent event) {
            questDirectories.remove(event.getInventory());
            questInventories.remove(event.getInventory());
        }
    }
}

