/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers.scripts;

import com.magmaguy.elitemobs.powers.scripts.EliteScript;
import com.magmaguy.elitemobs.powers.scripts.ScriptActionData;
import com.magmaguy.elitemobs.powers.scripts.ScriptTargets;
import com.magmaguy.elitemobs.powers.scripts.caching.ScriptRelativeVectorBlueprint;
import com.magmaguy.elitemobs.powers.scripts.enums.TargetType;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class ScriptRelativeVector {
    private final ScriptRelativeVectorBlueprint scriptRelativeVectorBlueprint;
    private ScriptTargets sourceTarget = null;
    private ScriptTargets destinationTarget = null;
    private Vector cachedVector = null;
    private Location actionLocation = null;
    private boolean sourceIsAction = false;
    private boolean destinationIsAction = false;

    public ScriptRelativeVector(ScriptRelativeVectorBlueprint scriptRelativeVectorBlueprint, EliteScript eliteScript, Location actionLocation) {
        this.scriptRelativeVectorBlueprint = scriptRelativeVectorBlueprint;
        this.actionLocation = actionLocation;
        if (!scriptRelativeVectorBlueprint.getSourceTarget().getTargetType().equals((Object)TargetType.ACTION_TARGET)) {
            this.sourceTarget = new ScriptTargets(scriptRelativeVectorBlueprint.getSourceTarget(), eliteScript);
        } else {
            this.sourceIsAction = true;
        }
        if (!scriptRelativeVectorBlueprint.getDestinationTarget().getTargetType().equals((Object)TargetType.ACTION_TARGET)) {
            this.destinationTarget = new ScriptTargets(scriptRelativeVectorBlueprint.getDestinationTarget(), eliteScript);
        } else {
            this.destinationIsAction = true;
        }
    }

    public Vector getVector(ScriptActionData scriptActionData) {
        if (this.cachedVector != null) {
            return this.cachedVector;
        }
        Location sourceLocation = null;
        if (this.sourceIsAction) {
            sourceLocation = this.actionLocation.clone();
        } else if (this.sourceTarget != null && !this.sourceTarget.getTargetLocations(scriptActionData).isEmpty()) {
            sourceLocation = this.sourceTarget.getTargetLocations(scriptActionData).iterator().next();
        } else {
            return new Vector(0, 0, 0);
        }
        Location destinationLocation = null;
        if (this.destinationIsAction) {
            destinationLocation = this.actionLocation.clone();
        } else if (this.destinationTarget != null && !this.destinationTarget.getTargetLocations(scriptActionData).isEmpty()) {
            destinationLocation = this.destinationTarget.getTargetLocations(scriptActionData).iterator().next().clone();
        } else {
            return new Vector(0, 0, 0);
        }
        if (!destinationLocation.getWorld().equals((Object)sourceLocation.getWorld())) {
            return new Vector(0, 0, 0);
        }
        Vector vector = destinationLocation.clone().subtract(sourceLocation).toVector();
        if (this.scriptRelativeVectorBlueprint.isNormalize()) {
            vector.normalize();
        }
        vector.multiply(this.scriptRelativeVectorBlueprint.getMultiplier().getValue().floatValue());
        vector.add(this.scriptRelativeVectorBlueprint.getOffset().getValue());
        return vector;
    }

    public void cacheVector(ScriptActionData scriptActionData) {
        this.cachedVector = this.getVector(scriptActionData);
    }
}

