/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers.scripts;

import com.magmaguy.elitemobs.powers.scripts.EliteScript;
import com.magmaguy.elitemobs.powers.scripts.ScriptActionData;
import com.magmaguy.elitemobs.powers.scripts.ScriptRelativeVector;
import com.magmaguy.elitemobs.powers.scripts.caching.ScriptParticlesBlueprint;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.util.Vector;

public class ScriptParticles {
    ScriptParticlesBlueprint particlesBlueprint;

    public ScriptParticles(ScriptParticlesBlueprint particlesBlueprint) {
        this.particlesBlueprint = particlesBlueprint;
    }

    public void visualize(ScriptActionData scriptActionData, Location location, EliteScript eliteScript) {
        this.particlesBlueprint.getParticleBlueprints().forEach(particleBlueprint -> new ScriptParticle(this, (ScriptParticlesBlueprint.ScriptParticleBlueprint)particleBlueprint).visualize(scriptActionData, location, eliteScript));
    }

    private class ScriptParticle {
        private final ScriptParticlesBlueprint.ScriptParticleBlueprint particleBlueprint;

        public ScriptParticle(ScriptParticles scriptParticles, ScriptParticlesBlueprint.ScriptParticleBlueprint scriptParticlesBlueprint) {
            this.particleBlueprint = scriptParticlesBlueprint;
        }

        private void visualize(ScriptActionData scriptActionData, Location location, EliteScript eliteScript) {
            double x = this.particleBlueprint.getX().getValue().floatValue();
            double y = this.particleBlueprint.getY().getValue().floatValue();
            double z = this.particleBlueprint.getZ().getValue().floatValue();
            int amount = this.particleBlueprint.getAmount().getValue();
            if (this.particleBlueprint.getRelativeVectorBlueprint() != null) {
                ScriptRelativeVector scriptRelativeVector = null;
                scriptRelativeVector = new ScriptRelativeVector(this.particleBlueprint.getRelativeVectorBlueprint(), eliteScript, location);
                Vector movementVector = scriptRelativeVector.getVector(scriptActionData);
                amount = 0;
                x = movementVector.getX();
                y = movementVector.getY();
                z = movementVector.getZ();
            }
            if (this.particleBlueprint.getParticle().equals((Object)Particle.DUST)) {
                location.getWorld().spawnParticle(this.particleBlueprint.getParticle(), location, amount, x, y, z, (double)this.particleBlueprint.getSpeed().getValue().floatValue(), (Object)new Particle.DustOptions(Color.fromRGB((int)this.particleBlueprint.getRed().getValue(), (int)this.particleBlueprint.getGreen().getValue(), (int)this.particleBlueprint.getBlue().getValue()), 1.0f));
            } else if (this.particleBlueprint.getParticle().equals((Object)Particle.DUST_COLOR_TRANSITION)) {
                location.getWorld().spawnParticle(this.particleBlueprint.getParticle(), location, amount, x, y, z, (double)this.particleBlueprint.getSpeed().getValue().floatValue(), (Object)new Particle.DustTransition(Color.fromRGB((int)this.particleBlueprint.getRed().getValue(), (int)this.particleBlueprint.getGreen().getValue(), (int)this.particleBlueprint.getBlue().getValue()), Color.fromRGB((int)this.particleBlueprint.getToRed().getValue(), (int)this.particleBlueprint.getToGreen().getValue(), (int)this.particleBlueprint.getToBlue().getValue()), 1.0f));
            } else if (this.particleBlueprint.getParticle().equals((Object)Particle.WITCH)) {
                location.getWorld().spawnParticle(this.particleBlueprint.getParticle(), x, y, z, amount, (double)this.particleBlueprint.getRed().getValue().intValue(), (double)this.particleBlueprint.getGreen().getValue().intValue(), (double)this.particleBlueprint.getBlue().getValue().intValue());
            } else {
                location.getWorld().spawnParticle(this.particleBlueprint.getParticle(), location, amount, x, y, z, (double)this.particleBlueprint.getSpeed().getValue().floatValue());
            }
        }
    }
}

