/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.api.internal.RemovalReason;
import com.magmaguy.elitemobs.config.MobCombatSettingsConfig;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.powers.meta.MajorPower;
import com.magmaguy.elitemobs.powerstances.GenericRotationMatrixMath;
import com.magmaguy.elitemobs.powerstances.VisualItemInitializer;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ZombieNecronomicon
extends MajorPower
implements Listener {
    private int chantIndex = 0;
    private final ArrayList<CustomBossEntity> entityList = new ArrayList();

    public ZombieNecronomicon() {
        super(PowersConfig.getPower("zombie_necronomicon.yml"));
    }

    @EventHandler
    public void onPlayerDetect(EliteMobDamagedByPlayerEvent event) {
        ZombieNecronomicon zombieNecronomicon = (ZombieNecronomicon)event.getEliteMobEntity().getPower(this);
        if (zombieNecronomicon == null) {
            return;
        }
        if (zombieNecronomicon.isFiring()) {
            return;
        }
        zombieNecronomicon.entityList.removeIf(entity -> !entity.exists());
        if (zombieNecronomicon.entityList.size() > 9) {
            return;
        }
        zombieNecronomicon.setFiring(true);
        this.necronomiconVisualEffect(event.getEliteMobEntity(), zombieNecronomicon);
        this.spawnReinforcements(event.getEliteMobEntity(), (LivingEntity)event.getPlayer(), zombieNecronomicon);
    }

    private void necronomiconVisualEffect(EliteEntity eliteEntity, final ZombieNecronomicon zombieNecronomicon) {
        final LivingEntity livingEntity = eliteEntity.getLivingEntity();
        livingEntity.setAI(false);
        zombieNecronomicon.setFiring(true);
        this.nameScroller(livingEntity, zombieNecronomicon);
        if (!MobCombatSettingsConfig.isEnableWarningVisualEffects()) {
            return;
        }
        new BukkitRunnable(){
            final HashMap<Integer, List<Item>> fourTrack = new HashMap();
            int counter = 0;

            public void run() {
                if (!livingEntity.isValid() || livingEntity.hasAI()) {
                    for (List<Item> itemList : this.fourTrack.values()) {
                        for (Item item : itemList) {
                            item.remove();
                        }
                    }
                    if (livingEntity.isValid()) {
                        livingEntity.setCustomName(EntityTracker.getEliteMobEntity((Entity)livingEntity).getName());
                    }
                    zombieNecronomicon.setFiring(false);
                    this.cancel();
                    return;
                }
                if (this.counter == 0) {
                    for (int i = 0; i < 8; ++i) {
                        ArrayList<Item> itemList = new ArrayList<Item>();
                        for (int j = 0; j < 4; ++j) {
                            ItemStack itemStack = new ItemStack(Material.WRITTEN_BOOK, 1);
                            Item item = VisualItemInitializer.initializeItem(itemStack, livingEntity.getLocation());
                            itemList.add(item);
                        }
                        this.fourTrack.put(i, itemList);
                    }
                } else {
                    ZombieNecronomicon.this.itemMover(this.fourTrack, (Entity)livingEntity, this.counter);
                }
                ++this.counter;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 5L, 5L);
    }

    private void itemMover(HashMap<Integer, List<Item>> xTrack, Entity entity, int counter) {
        double a = 0.0;
        double b = 1.0;
        double c = 0.0;
        double numberOfPointsPerFullRotation = 64.0;
        double x = 0.0;
        double y = 0.0;
        for (int trackNumber : xTrack.keySet()) {
            List<Item> itemList = xTrack.get(trackNumber);
            for (Item item : itemList) {
                double z = itemList.indexOf(item) + 1;
                int newCounter = (int)((double)counter + (double)trackNumber * (numberOfPointsPerFullRotation / 8.0));
                Location currentLocation = item.getLocation();
                Location centerLocationFixed = entity.getLocation().add(0.0, 3.0, 0.0);
                Vector vector = GenericRotationMatrixMath.applyRotation(a, b, c, numberOfPointsPerFullRotation, x, y, z, newCounter);
                Location newLocation = new Location(entity.getWorld(), vector.getX(), vector.getY(), vector.getZ()).add(centerLocationFixed);
                Vector velocity = newLocation.subtract(currentLocation).toVector().multiply(0.3);
                item.setVelocity(velocity);
            }
        }
    }

    private void nameScroller(final LivingEntity livingEntity, final ZombieNecronomicon zombieNecronomicon) {
        new BukkitRunnable(this){
            final String fullChant = ChatColorConverter.convert(PowersConfig.getPower("zombie_necronomicon.yml").getFileConfiguration().getString("summoningChant"));

            public void run() {
                if (!livingEntity.isValid() || livingEntity.hasAI()) {
                    this.cancel();
                    return;
                }
                if (zombieNecronomicon.chantIndex + 31 > this.fullChant.length()) {
                    zombieNecronomicon.chantIndex = 0;
                }
                String subString = this.fullChant.substring(zombieNecronomicon.chantIndex, zombieNecronomicon.chantIndex + 31);
                livingEntity.setCustomName(subString);
                ++zombieNecronomicon.chantIndex;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private void spawnReinforcements(final EliteEntity eliteEntity, final LivingEntity targetted, final ZombieNecronomicon zombieNecronomicon) {
        final LivingEntity targetter = eliteEntity.getLivingEntity();
        new BukkitRunnable(){

            public void run() {
                if (!eliteEntity.isValid() || !targetted.isValid() || !targetter.isValid() || targetted.getWorld() != targetter.getWorld() || targetted.getLocation().distance(targetter.getLocation()) > 30.0) {
                    for (CustomBossEntity entity : ZombieNecronomicon.this.entityList) {
                        if (!entity.isValid()) continue;
                        entity.remove(RemovalReason.REINFORCEMENT_CULL);
                    }
                    if (eliteEntity.isValid()) {
                        targetter.setAI(true);
                    }
                    this.cancel();
                    return;
                }
                int randomizedNumber = ThreadLocalRandom.current().nextInt(5) + 1;
                ZombieNecronomicon.this.entityList.removeIf(currentEntity -> !currentEntity.exists());
                if (ZombieNecronomicon.this.entityList.size() < 11) {
                    targetter.setAI(false);
                    if (!zombieNecronomicon.isFiring()) {
                        ZombieNecronomicon.this.necronomiconVisualEffect(eliteEntity, zombieNecronomicon);
                    }
                    if (randomizedNumber < 5) {
                        CustomBossEntity customBossEntity = CustomBossEntity.createCustomBossEntity("necronomicon_zombie.yml");
                        if (customBossEntity == null) {
                            Logger.warn("necronomicon_zombie.yml is not valid!");
                            return;
                        }
                        customBossEntity.spawn(targetter.getLocation(), eliteEntity.getLevel(), false);
                        if (!customBossEntity.exists() || !customBossEntity.getLivingEntity().isValid()) {
                            targetter.setAI(true);
                            this.cancel();
                            targetter.setAI(true);
                            this.cancel();
                            return;
                        }
                        customBossEntity.getLivingEntity().setVelocity(new Vector((ThreadLocalRandom.current().nextDouble() - 0.5) / 30.0, 0.5, (ThreadLocalRandom.current().nextDouble() - 0.5) / 30.0));
                        eliteEntity.addReinforcement(customBossEntity);
                        ZombieNecronomicon.this.entityList.add(customBossEntity);
                    } else {
                        CustomBossEntity customBossEntity = CustomBossEntity.createCustomBossEntity("necronomicon_skeleton.yml");
                        if (customBossEntity == null) {
                            Logger.warn("necronomicon_skeleton.yml is not valid!");
                            targetter.setAI(true);
                            this.cancel();
                            return;
                        }
                        customBossEntity.spawn(targetter.getLocation(), eliteEntity.getLevel(), false);
                        if (!customBossEntity.getLivingEntity().isValid()) {
                            targetter.setAI(true);
                            this.cancel();
                            return;
                        }
                        customBossEntity.getLivingEntity().setVelocity(new Vector((ThreadLocalRandom.current().nextDouble() - 0.5) / 30.0, 0.5, (ThreadLocalRandom.current().nextDouble() - 0.5) / 30.0));
                        eliteEntity.addReinforcement(customBossEntity);
                        ZombieNecronomicon.this.entityList.add(customBossEntity);
                    }
                } else {
                    targetter.setAI(true);
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 60L, 60L);
    }
}

