/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.events.BossCustomAttackDamage;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.BossPower;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Flamethrower
extends BossPower
implements Listener {
    public Flamethrower() {
        super(PowersConfig.getPower("flamethrower.yml"));
    }

    private static List<Location> generateDamagePoints(EliteEntity eliteEntity, Location fixedPlayerLocation) {
        ArrayList<Location> locations = new ArrayList<Location>();
        Location eliteMobLocation = eliteEntity.getLivingEntity().getLocation().clone();
        Vector toPlayerVector = fixedPlayerLocation.clone().subtract(eliteMobLocation).toVector().normalize().multiply(0.5);
        for (int i = 0; i < 40; ++i) {
            locations.add(eliteMobLocation.add(toPlayerVector).clone());
        }
        return locations;
    }

    private static void doDamage(List<Location> locations, EliteEntity eliteEntity) {
        for (Location location : locations) {
            for (Entity entity : location.getWorld().getNearbyEntities(location, 0.5, 0.5, 0.5)) {
                if (!(entity instanceof LivingEntity) || eliteEntity.getLivingEntity().equals((Object)entity)) continue;
                BossCustomAttackDamage.dealCustomDamage(eliteEntity.getLivingEntity(), (LivingEntity)entity, 1.0);
            }
        }
    }

    private void doFlamethrowerPhase1(final EliteEntity eliteEntity, final Location fixedPlayerLocation) {
        eliteEntity.getLivingEntity().setAI(false);
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (!eliteEntity.isValid()) {
                    this.cancel();
                    return;
                }
                Flamethrower.this.doParticleEffect(eliteEntity, fixedPlayerLocation, Particle.SMOKE);
                ++this.counter;
                if (this.counter < 40) {
                    return;
                }
                Flamethrower.this.doFlamethrowerPhase2(eliteEntity, fixedPlayerLocation);
                this.cancel();
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    @EventHandler
    public void onHit(EliteMobDamagedByPlayerEvent event) {
        Flamethrower flameThrower = (Flamethrower)event.getEliteMobEntity().getPower(this);
        if (flameThrower == null) {
            return;
        }
        if (!Flamethrower.eventIsValid(event, (ElitePower)flameThrower)) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() > 0.25) {
            return;
        }
        flameThrower.doGlobalCooldown(400, event.getEliteMobEntity());
        this.doFlamethrowerPhase1(event.getEliteMobEntity(), event.getPlayer().getLocation().clone());
    }

    private void doParticleEffect(EliteEntity eliteEntity, Location fixedPlayerLocation, Particle particle) {
        Vector directionVector = fixedPlayerLocation.clone().subtract(eliteEntity.getLivingEntity().getLocation()).toVector().normalize();
        for (int i = 0; i < 5; ++i) {
            eliteEntity.getLivingEntity().getWorld().spawnParticle(particle, eliteEntity.getLivingEntity().getEyeLocation().clone().add(directionVector.getX(), -0.5, directionVector.getZ()), 0, (ThreadLocalRandom.current().nextDouble() - 0.5) * 0.1 + directionVector.getX(), (ThreadLocalRandom.current().nextDouble() - 0.5) * 0.1 + directionVector.getY(), (ThreadLocalRandom.current().nextDouble() - 0.5) * 0.1 + directionVector.getZ(), ThreadLocalRandom.current().nextDouble() + 0.05);
        }
    }

    private void doFlamethrowerPhase2(final EliteEntity eliteEntity, final Location fixedPlayerLocation) {
        final List<Location> damagePoints = Flamethrower.generateDamagePoints(eliteEntity, fixedPlayerLocation);
        new BukkitRunnable(){
            int timer = 0;

            public void run() {
                if (!eliteEntity.isValid()) {
                    this.cancel();
                    return;
                }
                Flamethrower.this.doParticleEffect(eliteEntity, fixedPlayerLocation, Particle.FLAME);
                Flamethrower.doDamage(damagePoints, eliteEntity);
                ++this.timer;
                if (this.timer < 60) {
                    return;
                }
                Flamethrower.this.doFlamethrowerPhase3(eliteEntity, fixedPlayerLocation);
                this.cancel();
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private void doFlamethrowerPhase3(final EliteEntity eliteEntity, final Location fixedPlayerLocation) {
        new BukkitRunnable(){
            int timer = 0;

            public void run() {
                if (!eliteEntity.isValid()) {
                    this.cancel();
                    return;
                }
                ++this.timer;
                Flamethrower.this.doParticleEffect(eliteEntity, fixedPlayerLocation, Particle.SMOKE);
                if (this.timer < 20) {
                    return;
                }
                this.cancel();
                eliteEntity.getLivingEntity().setAI(true);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }
}

