/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.api.internal.RemovalReason;
import com.magmaguy.elitemobs.combatsystem.EliteProjectile;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.BossPower;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class BulletHell
extends BossPower
implements Listener {
    public BulletHell() {
        super(PowersConfig.getPower("bullet_hell.yml"));
    }

    private static void trackingArrowLoop(final Player player, final Arrow arrow) {
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (player.isValid() && !player.isDead() && arrow.isValid() && arrow.getWorld().equals((Object)player.getWorld()) && player.getLocation().distanceSquared(arrow.getLocation()) < 900.0 && !arrow.isOnGround()) {
                    if (this.counter % 10 == 0) {
                        arrow.setVelocity(arrow.getVelocity().add(BulletHell.arrowAdjustmentVector(arrow, player)));
                    }
                    arrow.getWorld().spawnParticle(Particle.FLAME, arrow.getLocation(), 10, 0.01, 0.01, 0.01, 0.01);
                } else {
                    arrow.setGravity(true);
                    EntityTracker.unregister((Entity)arrow, RemovalReason.EFFECT_TIMEOUT);
                    this.cancel();
                }
                if (this.counter > 200) {
                    EntityTracker.unregister((Entity)arrow, RemovalReason.EFFECT_TIMEOUT);
                    arrow.setGravity(true);
                    this.cancel();
                }
                ++this.counter;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private static Vector arrowAdjustmentVector(Arrow arrow, Player player) {
        return player.getEyeLocation().clone().subtract(new Vector(0.0, 0.5, 0.0)).subtract(arrow.getLocation()).toVector().normalize().multiply(0.2);
    }

    @EventHandler
    public void onDamage(EliteMobDamagedByPlayerEvent event) {
        BulletHell bulletHell = (BulletHell)event.getEliteMobEntity().getPower(this);
        if (bulletHell == null) {
            return;
        }
        if (!BulletHell.eventIsValid(event, (ElitePower)bulletHell)) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() > 0.25) {
            return;
        }
        bulletHell.doGlobalCooldown(400, event.getEliteMobEntity());
        this.doBulletHell(event.getEliteMobEntity());
    }

    public void doBulletHell(final EliteEntity eliteEntity) {
        eliteEntity.getLivingEntity().setAI(false);
        if (eliteEntity.getLivingEntity().getLocation().clone().add(new Vector(0, 10, 0)).getBlock().getType().equals((Object)Material.AIR)) {
            eliteEntity.getLivingEntity().teleport(eliteEntity.getLivingEntity().getLocation().clone().add(new Vector(0, 10, 0)));
        }
        new BukkitRunnable(this){
            final Location initialLocation;
            int counter;
            {
                this.initialLocation = eliteEntity.getLivingEntity().getLocation().clone();
                this.counter = 0;
            }

            public void run() {
                if (!eliteEntity.isValid()) {
                    this.cancel();
                    return;
                }
                eliteEntity.getLivingEntity().getWorld().spawnParticle(Particle.DRIPPING_WATER, eliteEntity.getLivingEntity().getLocation(), 10, 1.0, 1.0, 1.0);
                for (Entity nearbyEntity : eliteEntity.getLivingEntity().getNearbyEntities(20.0, 20.0, 20.0)) {
                    if (!(nearbyEntity instanceof Player) || !((Player)nearbyEntity).getGameMode().equals((Object)GameMode.ADVENTURE) && !((Player)nearbyEntity).getGameMode().equals((Object)GameMode.SURVIVAL)) continue;
                    Arrow arrow = (Arrow)EliteProjectile.create(EntityType.ARROW, (Entity)eliteEntity.getLivingEntity(), (Player)nearbyEntity, false);
                    arrow.setVelocity(arrow.getVelocity().multiply(0.1));
                    BulletHell.trackingArrowLoop((Player)nearbyEntity, arrow);
                }
                ++this.counter;
                if (this.counter > 20) {
                    this.cancel();
                    eliteEntity.getLivingEntity().setAI(true);
                    eliteEntity.getLivingEntity().teleport(this.initialLocation);
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 10L);
    }
}

