/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.playerdata.statusscreen;

import com.magmaguy.elitemobs.config.SkillsConfig;
import com.magmaguy.elitemobs.config.menus.premade.PlayerStatusMenuConfig;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.playerdata.statusscreen.CoverPage;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.SkillXPCalculator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SkillsPage {
    private SkillsPage() {
    }

    protected static TextComponent skillsPage(Player targetPlayer) {
        TextComponent textComponent = new TextComponent();
        TextComponent header = new TextComponent("\u00a75\u00a7lYour Skills\n\n");
        textComponent.addExtra((BaseComponent)header);
        for (SkillType skillType : SkillType.values()) {
            long totalXP = PlayerData.getSkillXP(targetPlayer.getUniqueId(), skillType);
            int level = SkillXPCalculator.levelFromTotalXP(totalXP);
            long xpInLevel = SkillXPCalculator.xpProgressInCurrentLevel(totalXP);
            long xpForNext = SkillXPCalculator.xpToNextLevel(level);
            double progress = SkillXPCalculator.levelProgress(totalXP);
            String progressBar = SkillsPage.createProgressBar(progress);
            TextComponent line = new TextComponent("\u00a76" + skillType.getDisplayName() + " \u00a77Lv.\u00a7e" + level + "\n\u00a78" + progressBar + " \u00a77" + SkillsPage.formatNumber(xpInLevel) + "/" + SkillsPage.formatNumber(xpForNext) + "\n\n");
            textComponent.addExtra((BaseComponent)line);
        }
        return textComponent;
    }

    protected static void skillsPage(Player targetPlayer, Player requestingPlayer) {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)requestingPlayer, (int)27, (String)SkillsConfig.getSkillsMenuTitle().replace("&", "\u00a7"));
        int[] skillSlots = new int[]{10, 11, 12, 13, 14, 15, 16};
        int slotIndex = 0;
        for (SkillType skillType : SkillType.values()) {
            if (slotIndex >= skillSlots.length) break;
            ItemStack skillItem = SkillsPage.createSkillItem(targetPlayer, skillType);
            inventory.setItem(skillSlots[slotIndex], skillItem);
            ++slotIndex;
        }
        inventory.setItem(26, PlayerStatusMenuConfig.getBackItem());
        requestingPlayer.openInventory(inventory);
        SkillsPageEvents.pageInventories.add(inventory);
    }

    private static ItemStack createSkillItem(Player player, SkillType skillType) {
        Material material = SkillsPage.getMaterialForSkill(skillType);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        long totalXP = PlayerData.getSkillXP(player.getUniqueId(), skillType);
        int level = SkillXPCalculator.levelFromTotalXP(totalXP);
        long xpInLevel = SkillXPCalculator.xpProgressInCurrentLevel(totalXP);
        long xpForNext = SkillXPCalculator.xpToNextLevel(level);
        double progress = SkillXPCalculator.levelProgress(totalXP);
        meta.setDisplayName("\u00a76\u00a7l" + skillType.getDisplayName() + " \u00a77- Level \u00a7e" + level);
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("");
        lore.add("\u00a77XP Progress:");
        lore.add("\u00a78" + SkillsPage.createProgressBar(progress));
        lore.add("\u00a77" + SkillsPage.formatNumber(xpInLevel) + " / " + SkillsPage.formatNumber(xpForNext) + " XP");
        lore.add("");
        lore.add("\u00a77Total XP: \u00a7e" + SkillsPage.formatNumber(totalXP));
        if (level < 200) {
            long killsNeeded = SkillXPCalculator.killsToNextLevel(level, level);
            lore.add("\u00a77Kills to next: \u00a7a~" + SkillsPage.formatNumber(killsNeeded));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private static Material getMaterialForSkill(SkillType skillType) {
        return switch (skillType) {
            default -> throw new MatchException(null, null);
            case SkillType.ARMOR -> Material.DIAMOND_CHESTPLATE;
            case SkillType.SWORDS -> Material.DIAMOND_SWORD;
            case SkillType.AXES -> Material.DIAMOND_AXE;
            case SkillType.BOWS -> Material.BOW;
            case SkillType.CROSSBOWS -> Material.CROSSBOW;
            case SkillType.TRIDENTS -> Material.TRIDENT;
            case SkillType.HOES -> Material.DIAMOND_HOE;
        };
    }

    private static String createProgressBar(double progress) {
        int i;
        int totalBars = 20;
        int filledBars = (int)(progress * (double)totalBars);
        int emptyBars = totalBars - filledBars;
        StringBuilder bar = new StringBuilder("\u00a7a");
        for (i = 0; i < filledBars; ++i) {
            bar.append("|");
        }
        bar.append("\u00a77");
        for (i = 0; i < emptyBars; ++i) {
            bar.append("|");
        }
        return bar.toString();
    }

    private static String formatNumber(long number) {
        if (number >= 1000000000L) {
            return String.format("%.1fB", (double)number / 1.0E9);
        }
        if (number >= 1000000L) {
            return String.format("%.1fM", (double)number / 1000000.0);
        }
        if (number >= 1000L) {
            return String.format("%.1fK", (double)number / 1000.0);
        }
        return String.valueOf(number);
    }

    public static class SkillsPageEvents
    implements Listener {
        private static final Set<Inventory> pageInventories = new HashSet<Inventory>();

        public static void shutdown() {
            pageInventories.clear();
        }

        @EventHandler
        public void onInventoryInteract(InventoryClickEvent event) {
            Player player = ((Player)event.getWhoClicked()).getPlayer();
            if (!pageInventories.contains(event.getInventory())) {
                return;
            }
            event.setCancelled(true);
            if (event.getSlot() == 26) {
                player.closeInventory();
                CoverPage.coverPage(player);
            }
        }

        @EventHandler
        public void onInventoryClose(InventoryCloseEvent event) {
            pageInventories.remove(event.getInventory());
        }
    }
}

