/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.playerdata.database;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.DatabaseConfig;
import com.magmaguy.elitemobs.dungeons.DungeonBossLockout;
import com.magmaguy.elitemobs.instanced.MatchInstance;
import com.magmaguy.elitemobs.playerdata.database.GenerateDatabase;
import com.magmaguy.elitemobs.playerdata.database.PortOldData;
import com.magmaguy.elitemobs.quests.CustomQuest;
import com.magmaguy.elitemobs.quests.Quest;
import com.magmaguy.elitemobs.quests.playercooldowns.PlayerQuestCooldowns;
import com.magmaguy.elitemobs.skills.CombatLevelCalculator;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.SkillXPCalculator;
import com.magmaguy.elitemobs.utils.ConfigurationLocation;
import com.magmaguy.elitemobs.utils.ObjectSerializer;
import com.magmaguy.magmacore.util.Logger;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerData {
    private static final String DATABASE_NAME = "player_data.db";
    private static final String PLAYER_DATA_TABLE_NAME = "PlayerData";
    private static final HashMap<UUID, PlayerData> playerDataHashMap = new HashMap();
    private static Connection connection = null;
    private double currency;
    private int score;
    private int kills;
    private int highestLevelKilled;
    private int deaths;
    private int questsCompleted;
    private List<Quest> quests = new ArrayList<Quest>();
    private PlayerQuestCooldowns playerQuestCooldowns = null;
    private Location backTeleportLocation;
    private boolean useBookMenus;
    private boolean dismissEMStatusScreenMessage;
    private MatchInstance matchInstance = null;
    private DungeonBossLockout dungeonBossLockout = null;
    private long skillXP_ARMOR = 0L;
    private long skillXP_SWORDS = 0L;
    private long skillXP_AXES = 0L;
    private long skillXP_BOWS = 0L;
    private long skillXP_CROSSBOWS = 0L;
    private long skillXP_TRIDENTS = 0L;
    private long skillXP_HOES = 0L;
    private String skillBonusSelections = "{}";

    public PlayerData(final UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            Logger.warn("EliteMobs did not initialize player data for uuid " + String.valueOf(uuid) + " because Minecraft does not recognize this as a valid player!");
            return;
        }
        PermissionAttachment permissionAttachment = player.addAttachment((Plugin)MetadataHandler.PLUGIN);
        permissionAttachment.setPermission("elitequest.*", false);
        new BukkitRunnable(){

            public void run() {
                Statement statement = null;
                try {
                    statement = PlayerData.getConnection().createStatement();
                    ResultSet resultSet = statement.executeQuery("SELECT * FROM PlayerData WHERE PlayerUUID = '" + String.valueOf(uuid) + "';");
                    if (resultSet.next()) {
                        PlayerData.this.readExistingData(statement, uuid, resultSet);
                    } else {
                        PlayerData.this.writeNewData(statement, uuid);
                    }
                    resultSet.close();
                    statement.close();
                }
                catch (Exception e) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException throwables) {
                            Logger.warn("Failed to close statement after failing player data creation!");
                            throwables.printStackTrace();
                        }
                    }
                    Logger.warn("Something went wrong while generating a new player entry. This is bad! Tell the dev.");
                    Logger.warn(e.getClass().getName() + ": " + e.getMessage());
                }
            }
        }.runTaskAsynchronously((Plugin)MetadataHandler.PLUGIN);
    }

    public static PlayerData getPlayerData(UUID player) {
        return playerDataHashMap.get(player);
    }

    public static void updateQuestStatus(UUID uuid) {
        List<Quest> playerQuests = PlayerData.getQuests(uuid);
        try {
            PlayerData.setDatabaseValue(uuid, "QuestStatus", ObjectSerializer.toString((ArrayList)playerQuests));
            if (playerDataHashMap.containsKey(uuid)) {
                PlayerData.playerDataHashMap.get((Object)uuid).quests = playerQuests;
            }
        }
        catch (Exception ex) {
            Logger.warn("Failed to serialize player quest data!");
            ex.printStackTrace();
        }
    }

    public static void clearPlayerData(UUID uuid) {
        playerDataHashMap.remove(uuid);
    }

    public static boolean isInMemory(Player player) {
        return playerDataHashMap.containsKey(player.getUniqueId());
    }

    public static boolean isInMemory(UUID uuid) {
        return playerDataHashMap.containsKey(uuid);
    }

    public static String getDisplayName(UUID uuid) {
        if (!PlayerData.isInMemory(uuid)) {
            return PlayerData.getDatabaseString(uuid, "DisplayName");
        }
        return Bukkit.getPlayer((UUID)uuid).getCustomName();
    }

    public static void setDisplayName(UUID uuid, String displayName) {
        PlayerData.setDatabaseValue(uuid, "DisplayName", displayName);
    }

    public static double getCurrency(UUID uuid) {
        if (!PlayerData.isInMemory(uuid)) {
            return PlayerData.getDatabaseDouble(uuid, "Currency");
        }
        return PlayerData.playerDataHashMap.get((Object)uuid).currency;
    }

    public static double getCurrency(UUID uuid, boolean databaseAccess) {
        if (!PlayerData.isInMemory(uuid)) {
            if (databaseAccess) {
                return PlayerData.getDatabaseDouble(uuid, "Currency");
            }
            return 0.0;
        }
        return PlayerData.playerDataHashMap.get((Object)uuid).currency;
    }

    public static void setCurrency(UUID uuid, double currency) {
        PlayerData.setDatabaseValue(uuid, "Currency", currency);
        if (playerDataHashMap.containsKey(uuid)) {
            PlayerData.playerDataHashMap.get((Object)uuid).currency = currency;
        }
    }

    public static List<Quest> getQuests(UUID uuid) {
        try {
            if (!PlayerData.isInMemory(uuid)) {
                return (List)ObjectSerializer.fromString((String)PlayerData.getDatabaseBlob(uuid, "QuestStatus"));
            }
            if (playerDataHashMap.get(uuid) == null) {
                return new ArrayList<Quest>();
            }
            return PlayerData.playerDataHashMap.get((Object)uuid).quests == null ? new ArrayList<Quest>() : PlayerData.playerDataHashMap.get((Object)uuid).quests;
        }
        catch (Exception ex) {
            return new ArrayList<Quest>();
        }
    }

    public static Quest getQuest(UUID uuid, String questID) {
        try {
            UUID questUUID = UUID.fromString(questID);
            return PlayerData.getQuest(uuid, questUUID);
        }
        catch (Exception ex) {
            Logger.warn("Failed to convert quest ID from command into a valid UUID format!");
            return null;
        }
    }

    public static Quest getQuest(UUID uuid, UUID questUUID) {
        List questList = null;
        try {
            questList = !PlayerData.isInMemory(uuid) ? (List)ObjectSerializer.fromString((String)PlayerData.getDatabaseBlob(uuid, "QuestStatus")) : PlayerData.playerDataHashMap.get((Object)uuid).quests;
        }
        catch (Exception ex) {
            return null;
        }
        for (Quest iteratedQuest : questList) {
            if (!iteratedQuest.getQuestID().equals(questUUID)) continue;
            return iteratedQuest;
        }
        return null;
    }

    public static void resetQuests(UUID uuid) {
        PlayerData.getQuests(uuid).clear();
        PlayerData.updateQuestStatus(uuid);
    }

    public static void removeQuest(UUID uuid, Quest quest) {
        if (quest == null) {
            return;
        }
        PlayerData.playerDataHashMap.get((Object)uuid).quests.removeIf(iteratedQuest -> iteratedQuest.getQuestID().equals(quest.getQuestID()));
        PlayerData.updateQuestStatus(uuid);
    }

    public static void addQuest(UUID uuid, Quest quest) {
        PlayerData.playerDataHashMap.get((Object)uuid).quests.add(quest);
        PlayerData.updateQuestStatus(uuid);
    }

    public static void updateQuestStatus(UUID uuid, Quest quest) {
        PlayerData.updateQuestStatus(uuid);
    }

    @Nullable
    public static PlayerQuestCooldowns getPlayerQuestCooldowns(UUID uuid) {
        try {
            if (!PlayerData.isInMemory(uuid)) {
                return (PlayerQuestCooldowns)ObjectSerializer.fromString((String)PlayerData.getDatabaseBlob(uuid, "PlayerQuestCooldowns"));
            }
            if (playerDataHashMap.get(uuid) == null) {
                return PlayerQuestCooldowns.initializePlayer();
            }
            return PlayerData.playerDataHashMap.get((Object)uuid).playerQuestCooldowns == null ? PlayerQuestCooldowns.initializePlayer() : PlayerData.playerDataHashMap.get((Object)uuid).playerQuestCooldowns;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void resetPlayerQuestCooldowns(UUID uuid) {
        PlayerData.updatePlayerQuestCooldowns(uuid, PlayerQuestCooldowns.initializePlayer());
    }

    public static void updatePlayerQuestCooldowns(UUID uuid, PlayerQuestCooldowns playerQuestCooldowns) {
        try {
            PlayerData.setDatabaseValue(uuid, "PlayerQuestCooldowns", ObjectSerializer.toString(playerQuestCooldowns));
        }
        catch (Exception ex) {
            Logger.warn("Failed to register player quest cooldowns!");
            ex.printStackTrace();
        }
    }

    @Nullable
    public static DungeonBossLockout getDungeonBossLockout(UUID uuid) {
        try {
            if (!PlayerData.isInMemory(uuid)) {
                return (DungeonBossLockout)ObjectSerializer.fromString((String)PlayerData.getDatabaseBlob(uuid, "DungeonBossLockouts"));
            }
            if (playerDataHashMap.get(uuid) == null) {
                return new DungeonBossLockout();
            }
            return PlayerData.playerDataHashMap.get((Object)uuid).dungeonBossLockout == null ? new DungeonBossLockout() : PlayerData.playerDataHashMap.get((Object)uuid).dungeonBossLockout;
        }
        catch (Exception ex) {
            return new DungeonBossLockout();
        }
    }

    public static void updateDungeonBossLockout(UUID uuid, DungeonBossLockout dungeonBossLockout) {
        try {
            dungeonBossLockout.cleanupExpiredLockouts();
            PlayerData.setDatabaseValue(uuid, "DungeonBossLockouts", ObjectSerializer.toString(dungeonBossLockout));
            if (playerDataHashMap.containsKey(uuid)) {
                PlayerData.playerDataHashMap.get((Object)uuid).dungeonBossLockout = dungeonBossLockout;
            }
        }
        catch (Exception ex) {
            Logger.warn("Failed to update dungeon boss lockouts!");
            ex.printStackTrace();
        }
    }

    public static void setDatabaseValue(final UUID uuid, final String key, final Object value) {
        new BukkitRunnable(){

            public void run() {
                Statement statement = null;
                try {
                    statement = PlayerData.getConnection().createStatement();
                    String sql = value instanceof String ? "UPDATE PlayerData SET " + key + " = '" + String.valueOf(value) + "' WHERE PlayerUUID = '" + uuid.toString() + "';" : (value instanceof Boolean ? "UPDATE PlayerData SET " + key + " = " + ((Boolean)value != false ? 1 : 0) + " WHERE PlayerUUID = '" + uuid.toString() + "';" : "UPDATE PlayerData SET " + key + " = " + String.valueOf(value) + " WHERE PlayerUUID = '" + uuid.toString() + "';");
                    statement.executeUpdate(sql);
                    statement.close();
                }
                catch (Exception e) {
                    Logger.warn("Failed to update database value.");
                    e.printStackTrace();
                }
            }
        }.runTaskAsynchronously((Plugin)MetadataHandler.PLUGIN);
    }

    private static Object getDatabaseBlob(UUID uuid, String value) {
        try {
            Statement statement = PlayerData.getConnection().createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * FROM PlayerData WHERE PlayerUUID = '" + uuid.toString() + "';");
            byte[] bytes = resultSet.getBytes(value);
            resultSet.close();
            statement.close();
            if (bytes == null) {
                return null;
            }
            return new String(bytes);
        }
        catch (Exception e) {
            Logger.warn("Failed to get blob value from database!");
            Logger.warn("UUID: " + String.valueOf(uuid) + " | Value: " + value);
            e.printStackTrace();
            return null;
        }
    }

    public static int getScore(UUID uuid) {
        if (!PlayerData.isInMemory(uuid)) {
            return PlayerData.getDatabaseInteger(uuid, "Score");
        }
        return PlayerData.playerDataHashMap.get((Object)uuid).score;
    }

    public static void incrementScore(UUID uuid, int levelToIncrement) {
        PlayerData.setDatabaseValue(uuid, "Score", PlayerData.getScore(uuid) + levelToIncrement * 2);
        if (playerDataHashMap.containsKey(uuid)) {
            PlayerData.playerDataHashMap.get((Object)uuid).score += levelToIncrement * 2;
        }
    }

    public static void decrementScore(UUID uuid) {
        PlayerData.setDatabaseValue(uuid, "Score", PlayerData.getScore(uuid) - 100);
        if (playerDataHashMap.containsKey(uuid)) {
            PlayerData.playerDataHashMap.get((Object)uuid).score -= 100;
        }
    }

    public static int getKills(UUID uuid) {
        if (!PlayerData.isInMemory(uuid)) {
            return PlayerData.getDatabaseInteger(uuid, "Kills");
        }
        return PlayerData.playerDataHashMap.get((Object)uuid).kills;
    }

    public static void incrementKills(UUID uuid) {
        PlayerData.setDatabaseValue(uuid, "Kills", PlayerData.getKills(uuid) + 1);
        if (playerDataHashMap.containsKey(uuid)) {
            ++PlayerData.playerDataHashMap.get((Object)uuid).kills;
        }
    }

    public static int getHighestLevelKilled(UUID uuid) {
        if (!PlayerData.isInMemory(uuid)) {
            return PlayerData.getDatabaseInteger(uuid, "HighestLevelKilled");
        }
        return PlayerData.playerDataHashMap.get((Object)uuid).highestLevelKilled;
    }

    public static void setHighestLevelKilled(UUID uuid, int tentativeNewLevel) {
        if (tentativeNewLevel < PlayerData.getHighestLevelKilled(uuid)) {
            return;
        }
        PlayerData.setDatabaseValue(uuid, "HighestLevelKilled", tentativeNewLevel);
        if (playerDataHashMap.containsKey(uuid)) {
            PlayerData.playerDataHashMap.get((Object)uuid).highestLevelKilled = tentativeNewLevel;
        }
    }

    public static int getDeaths(UUID uuid) {
        if (!PlayerData.isInMemory(uuid)) {
            return PlayerData.getDatabaseInteger(uuid, "Deaths");
        }
        return PlayerData.playerDataHashMap.get((Object)uuid).deaths;
    }

    public static void incrementDeaths(UUID uuid) {
        PlayerData.setDatabaseValue(uuid, "Deaths", PlayerData.getDeaths(uuid) + 1);
        if (playerDataHashMap.containsKey(uuid)) {
            ++PlayerData.playerDataHashMap.get((Object)uuid).deaths;
        }
    }

    public static int getQuestsCompleted(UUID uuid) {
        if (!PlayerData.isInMemory(uuid)) {
            return PlayerData.getDatabaseInteger(uuid, "QuestsCompleted");
        }
        return PlayerData.playerDataHashMap.get((Object)uuid).questsCompleted;
    }

    public static void incrementQuestsCompleted(UUID uuid) {
        PlayerData.setDatabaseValue(uuid, "QuestsCompleted", PlayerData.getQuestsCompleted(uuid) + 1);
        if (playerDataHashMap.containsKey(uuid)) {
            ++PlayerData.playerDataHashMap.get((Object)uuid).questsCompleted;
        }
    }

    public static Location getBackTeleportLocation(Player player) {
        if (!PlayerData.isInMemory(player.getUniqueId())) {
            return ConfigurationLocation.serialize(PlayerData.getDatabaseString(player.getUniqueId(), "BackTeleportLocation"));
        }
        return PlayerData.playerDataHashMap.get((Object)player.getUniqueId()).backTeleportLocation;
    }

    public static void setBackTeleportLocation(Player player, Location location) {
        PlayerData.setDatabaseValue(player.getUniqueId(), "BackTeleportLocation", ConfigurationLocation.deserialize(location));
        PlayerData.playerDataHashMap.get((Object)player.getUniqueId()).backTeleportLocation = location;
    }

    public static boolean getUseBookMenus(UUID uuid) {
        if (!PlayerData.isInMemory(uuid)) {
            return PlayerData.getDatabaseBoolean(uuid, "UseBookMenus");
        }
        return PlayerData.playerDataHashMap.get((Object)uuid).useBookMenus;
    }

    public static void setUseBookMenus(Player player, boolean use) {
        PlayerData.setDatabaseValue(player.getUniqueId(), "UseBookMenus", use);
        PlayerData.playerDataHashMap.get((Object)player.getUniqueId()).useBookMenus = use;
    }

    public static boolean getDismissEMStatusScreenMessage(UUID uuid) {
        if (!PlayerData.isInMemory(uuid)) {
            return PlayerData.getDatabaseBoolean(uuid, "DismissEMStatusScreenMessage");
        }
        return PlayerData.playerDataHashMap.get((Object)uuid).dismissEMStatusScreenMessage;
    }

    public static void setDismissEMStatusScreenMessage(Player player, boolean use) {
        PlayerData.setDatabaseValue(player.getUniqueId(), "DismissEMStatusScreenMessage", use);
        PlayerData.playerDataHashMap.get((Object)player.getUniqueId()).dismissEMStatusScreenMessage = use;
    }

    public static MatchInstance getMatchInstance(Player player) {
        if (player == null || playerDataHashMap.get(player.getUniqueId()) == null) {
            return null;
        }
        return PlayerData.playerDataHashMap.get((Object)player.getUniqueId()).matchInstance;
    }

    public static void setMatchInstance(Player player, MatchInstance newMatchInstance) {
        if (playerDataHashMap.get(player.getUniqueId()) != null) {
            PlayerData.playerDataHashMap.get((Object)player.getUniqueId()).matchInstance = newMatchInstance;
        }
    }

    public static long getSkillXP(UUID uuid, SkillType skillType) {
        String columnName = skillType.getColumnName();
        if (!PlayerData.isInMemory(uuid)) {
            return PlayerData.getDatabaseLong(uuid, columnName);
        }
        return PlayerData.getSkillXPByType(playerDataHashMap.get(uuid), skillType);
    }

    public static void setSkillXP(UUID uuid, SkillType skillType, long xp) {
        String columnName = skillType.getColumnName();
        PlayerData.setDatabaseValue(uuid, columnName, xp);
        if (playerDataHashMap.containsKey(uuid)) {
            PlayerData.setSkillXPByType(playerDataHashMap.get(uuid), skillType, xp);
        }
    }

    public static long addSkillXP(UUID uuid, SkillType skillType, long xpToAdd) {
        long currentXP = PlayerData.getSkillXP(uuid, skillType);
        long newXP = currentXP + xpToAdd;
        PlayerData.setSkillXP(uuid, skillType, newXP);
        return newXP;
    }

    public static long[] getAllSkillXP(UUID uuid) {
        long[] xpArray = new long[SkillType.values().length];
        for (SkillType skillType : SkillType.values()) {
            xpArray[skillType.ordinal()] = PlayerData.getSkillXP(uuid, skillType);
        }
        return xpArray;
    }

    public static int getPlayerLevel(UUID uuid) {
        return CombatLevelCalculator.calculateCombatLevel(uuid);
    }

    public static int getSkillLevel(UUID uuid, SkillType skillType) {
        long xp = PlayerData.getSkillXP(uuid, skillType);
        return SkillXPCalculator.levelFromTotalXP(xp);
    }

    private static long getSkillXPByType(PlayerData playerData, SkillType skillType) {
        return switch (skillType) {
            default -> throw new MatchException(null, null);
            case SkillType.ARMOR -> playerData.skillXP_ARMOR;
            case SkillType.SWORDS -> playerData.skillXP_SWORDS;
            case SkillType.AXES -> playerData.skillXP_AXES;
            case SkillType.BOWS -> playerData.skillXP_BOWS;
            case SkillType.CROSSBOWS -> playerData.skillXP_CROSSBOWS;
            case SkillType.TRIDENTS -> playerData.skillXP_TRIDENTS;
            case SkillType.HOES -> playerData.skillXP_HOES;
        };
    }

    private static void setSkillXPByType(PlayerData playerData, SkillType skillType, long xp) {
        switch (skillType) {
            case ARMOR: {
                playerData.skillXP_ARMOR = xp;
                break;
            }
            case SWORDS: {
                playerData.skillXP_SWORDS = xp;
                break;
            }
            case AXES: {
                playerData.skillXP_AXES = xp;
                break;
            }
            case BOWS: {
                playerData.skillXP_BOWS = xp;
                break;
            }
            case CROSSBOWS: {
                playerData.skillXP_CROSSBOWS = xp;
                break;
            }
            case TRIDENTS: {
                playerData.skillXP_TRIDENTS = xp;
                break;
            }
            case HOES: {
                playerData.skillXP_HOES = xp;
            }
        }
    }

    public static String getSkillBonusSelections(UUID uuid) {
        if (!PlayerData.isInMemory(uuid)) {
            String dbValue = PlayerData.getDatabaseString(uuid, "SkillBonusSelections");
            return dbValue != null ? dbValue : "{}";
        }
        PlayerData data = playerDataHashMap.get(uuid);
        return data != null ? data.skillBonusSelections : "{}";
    }

    public static void setSkillBonusSelections(UUID uuid, String selections) {
        PlayerData.setDatabaseValue(uuid, "SkillBonusSelections", selections);
        if (playerDataHashMap.containsKey(uuid)) {
            PlayerData.playerDataHashMap.get((Object)uuid).skillBonusSelections = selections;
        }
    }

    private static Boolean getDatabaseBoolean(UUID uuid, String value) {
        try {
            Statement statement = PlayerData.getConnection().createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * FROM PlayerData WHERE PlayerUUID = '" + uuid.toString() + "';");
            boolean reply = resultSet.getBoolean(value);
            resultSet.close();
            statement.close();
            return reply;
        }
        catch (Exception e) {
            Logger.warn("Failed to get boolean value from database!");
            e.printStackTrace();
            return null;
        }
    }

    private static String getDatabaseString(UUID uuid, String value) {
        try {
            Statement statement = PlayerData.getConnection().createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * FROM PlayerData WHERE PlayerUUID = '" + uuid.toString() + "';");
            String reply = resultSet.getString(value);
            resultSet.close();
            statement.close();
            return reply;
        }
        catch (Exception e) {
            Logger.warn("Failed to get string value from database!");
            e.printStackTrace();
            return null;
        }
    }

    private static Double getDatabaseDouble(UUID uuid, String value) {
        try {
            Statement statement = PlayerData.getConnection().createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * FROM PlayerData WHERE PlayerUUID = '" + uuid.toString() + "';");
            double reply = resultSet.getDouble(value);
            resultSet.close();
            statement.close();
            return reply;
        }
        catch (Exception e) {
            Logger.warn("Failed to get double value from database!");
            e.printStackTrace();
            return null;
        }
    }

    private static Integer getDatabaseInteger(UUID uuid, String value) {
        try {
            Statement statement = PlayerData.getConnection().createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * FROM PlayerData WHERE PlayerUUID = '" + uuid.toString() + "';");
            int reply = resultSet.getInt(value);
            resultSet.close();
            statement.close();
            return reply;
        }
        catch (Exception e) {
            Logger.warn("Failed to get integer value from database!");
            e.printStackTrace();
            return null;
        }
    }

    private static Long getDatabaseLong(UUID uuid, String value) {
        try {
            Statement statement = PlayerData.getConnection().createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * FROM PlayerData WHERE PlayerUUID = '" + uuid.toString() + "';");
            long reply = resultSet.getLong(value);
            resultSet.close();
            statement.close();
            return reply;
        }
        catch (Exception e) {
            Logger.warn("Failed to get long value from database!");
            e.printStackTrace();
            return 0L;
        }
    }

    public static Connection getConnection() throws Exception {
        File dataFolder = new File(MetadataHandler.PLUGIN.getDataFolder(), "data/player_data.db");
        if (connection == null || connection.isClosed()) {
            if (!DatabaseConfig.isUseMySQL()) {
                Class.forName("org.sqlite.JDBC");
                connection = DriverManager.getConnection("jdbc:sqlite:" + String.valueOf(dataFolder));
                connection.setAutoCommit(true);
            } else {
                Class.forName("com.mysql.jdbc.Driver");
                String URL2 = "jdbc:mysql://" + DatabaseConfig.getMysqlHost() + ":" + DatabaseConfig.getMysqlPort() + "/" + DatabaseConfig.mysqlDatabaseName + "?useSSL=" + DatabaseConfig.useSSL + "&createDatabaseIfNotExist=true";
                String USER = DatabaseConfig.getMysqlUsername();
                String PASS = DatabaseConfig.getMysqlPassword();
                connection = DriverManager.getConnection(URL2, USER, PASS);
                connection.setAutoCommit(true);
            }
        }
        return connection;
    }

    public static void initializeDatabaseConnection() {
        new File(MetadataHandler.PLUGIN.getDataFolder().getPath() + "/data").mkdirs();
        try {
            Logger.info("Opened database successfully");
            GenerateDatabase.generate();
            for (Player player : Bukkit.getOnlinePlayers()) {
                new PlayerData(player.getUniqueId());
            }
        }
        catch (Exception e) {
            Logger.warn(e.getClass().getName() + ": " + e.getMessage());
            Logger.warn("Failed to establish a connection to the SQLite database. Player data will not be saved! Is your MySQL configuration valid and is your MySQL server running?");
            e.printStackTrace();
        }
        new PortOldData();
    }

    public static void closeConnection() {
        playerDataHashMap.clear();
        try {
            if (connection == null) {
                return;
            }
            connection.close();
        }
        catch (Exception ex) {
            Logger.warn("Could not correctly close database connection.");
        }
    }

    private void readExistingData(Statement statement, UUID uuid, ResultSet resultSet) throws Exception {
        playerDataHashMap.put(uuid, this);
        this.currency = resultSet.getDouble("Currency");
        this.score = resultSet.getInt("Score");
        this.kills = resultSet.getInt("Kills");
        this.highestLevelKilled = resultSet.getInt("HighestLevelKilled");
        this.deaths = resultSet.getInt("Deaths");
        this.questsCompleted = resultSet.getInt("QuestsCompleted");
        this.backTeleportLocation = ConfigurationLocation.serialize(resultSet.getString("BackTeleportLocation"));
        if (resultSet.getBytes("QuestStatus") != null) {
            try {
                this.quests = (List)ObjectSerializer.fromString(new String(resultSet.getBytes("QuestStatus"), StandardCharsets.UTF_8));
                for (Quest quest : this.quests) {
                    if (!(quest instanceof CustomQuest)) continue;
                    ((CustomQuest)quest).applyTemporaryPermissions(Bukkit.getPlayer((UUID)uuid));
                }
            }
            catch (Exception ex) {
                Logger.warn("Failed to serialize quest data for player " + String.valueOf(Bukkit.getPlayer((UUID)uuid)) + " ! This player's quest data will be wiped to prevent future errors.");
                try {
                    PlayerData.resetQuests(uuid);
                }
                catch (Exception ex2) {
                    Logger.warn("Failed to reset quest data! Ironic.");
                    ex2.printStackTrace();
                }
            }
        }
        if (resultSet.getBytes("PlayerQuestCooldowns") != null) {
            try {
                this.playerQuestCooldowns = (PlayerQuestCooldowns)ObjectSerializer.fromString(new String(resultSet.getBytes("PlayerQuestCooldowns"), StandardCharsets.UTF_8));
                this.playerQuestCooldowns.startCooldowns(uuid);
            }
            catch (Exception exception) {
                Logger.warn("Failed to get player quest cooldowns!  ! This player's quest cooldowns will be wiped to prevent future errors.");
                try {
                    PlayerData.resetPlayerQuestCooldowns(uuid);
                }
                catch (Exception ex2) {
                    Logger.warn("Failed to reset quest cooldowns! Ironic.");
                    ex2.printStackTrace();
                }
            }
        }
        if (resultSet.getObject("UseBookMenus") != null) {
            this.useBookMenus = resultSet.getBoolean("UseBookMenus");
        } else {
            PlayerData.setUseBookMenus(Bukkit.getPlayer((UUID)uuid), true);
        }
        if (resultSet.getObject("DismissEMStatusScreenMessage") != null) {
            this.dismissEMStatusScreenMessage = resultSet.getBoolean("DismissEMStatusScreenMessage");
        } else {
            PlayerData.setDismissEMStatusScreenMessage(Bukkit.getPlayer((UUID)uuid), false);
        }
        if (resultSet.getBytes("DungeonBossLockouts") != null) {
            try {
                this.dungeonBossLockout = (DungeonBossLockout)ObjectSerializer.fromString(new String(resultSet.getBytes("DungeonBossLockouts"), StandardCharsets.UTF_8));
                this.dungeonBossLockout.cleanupExpiredLockouts();
            }
            catch (Exception exception) {
                Logger.warn("Failed to get dungeon boss lockouts! This player's lockouts will be reset.");
                this.dungeonBossLockout = new DungeonBossLockout();
            }
        } else {
            this.dungeonBossLockout = new DungeonBossLockout();
        }
        this.skillXP_ARMOR = resultSet.getLong("SkillXP_ARMOR");
        this.skillXP_SWORDS = resultSet.getLong("SkillXP_SWORDS");
        this.skillXP_AXES = resultSet.getLong("SkillXP_AXES");
        this.skillXP_BOWS = resultSet.getLong("SkillXP_BOWS");
        this.skillXP_CROSSBOWS = resultSet.getLong("SkillXP_CROSSBOWS");
        this.skillXP_TRIDENTS = resultSet.getLong("SkillXP_TRIDENTS");
        this.skillXP_HOES = resultSet.getLong("SkillXP_HOES");
        String skillSelections = resultSet.getString("SkillBonusSelections");
        this.skillBonusSelections = skillSelections != null ? skillSelections : "{}";
        Logger.info("User " + String.valueOf(uuid) + " data successfully read!");
    }

    private void writeNewData(Statement statement, UUID uuid) throws Exception {
        playerDataHashMap.put(uuid, this);
        this.currency = 0.0;
        this.score = 0;
        this.kills = 0;
        this.highestLevelKilled = 0;
        this.deaths = 0;
        this.questsCompleted = 0;
        this.skillXP_ARMOR = 0L;
        this.skillXP_SWORDS = 0L;
        this.skillXP_AXES = 0L;
        this.skillXP_BOWS = 0L;
        this.skillXP_CROSSBOWS = 0L;
        this.skillXP_TRIDENTS = 0L;
        this.skillXP_HOES = 0L;
        this.skillBonusSelections = "{}";
        statement = PlayerData.getConnection().createStatement();
        String sql = "INSERT INTO PlayerData (PlayerUUID, DisplayName, Currency, Score, Kills, HighestLevelKilled, Deaths, QuestsCompleted, SkillXP_ARMOR, SkillXP_SWORDS, SkillXP_AXES, SkillXP_BOWS, SkillXP_CROSSBOWS, SkillXP_TRIDENTS, SkillXP_HOES, SkillBonusSelections) VALUES ('" + String.valueOf(uuid) + "', '" + Bukkit.getPlayer((UUID)uuid).getName() + "', 0,0,0,0,0,0,0,0,0,0,0,0,0,'{}');";
        statement.executeUpdate(sql);
        statement.close();
        Logger.info("No player entry detected, generating new entry!");
    }

    @Generated
    public static String getDATABASE_NAME() {
        return DATABASE_NAME;
    }

    @Generated
    public static String getPLAYER_DATA_TABLE_NAME() {
        return PLAYER_DATA_TABLE_NAME;
    }

    @Generated
    public static HashMap<UUID, PlayerData> getPlayerDataHashMap() {
        return playerDataHashMap;
    }

    @Generated
    public double getCurrency() {
        return this.currency;
    }

    @Generated
    public void setCurrency(double currency) {
        this.currency = currency;
    }

    @Generated
    public int getScore() {
        return this.score;
    }

    @Generated
    public void setScore(int score) {
        this.score = score;
    }

    @Generated
    public int getKills() {
        return this.kills;
    }

    @Generated
    public void setKills(int kills) {
        this.kills = kills;
    }

    @Generated
    public int getHighestLevelKilled() {
        return this.highestLevelKilled;
    }

    @Generated
    public void setHighestLevelKilled(int highestLevelKilled) {
        this.highestLevelKilled = highestLevelKilled;
    }

    @Generated
    public int getDeaths() {
        return this.deaths;
    }

    @Generated
    public void setDeaths(int deaths) {
        this.deaths = deaths;
    }

    @Generated
    public int getQuestsCompleted() {
        return this.questsCompleted;
    }

    @Generated
    public void setQuestsCompleted(int questsCompleted) {
        this.questsCompleted = questsCompleted;
    }

    @Generated
    public List<Quest> getQuests() {
        return this.quests;
    }

    @Generated
    public void setQuests(List<Quest> quests) {
        this.quests = quests;
    }

    @Generated
    public PlayerQuestCooldowns getPlayerQuestCooldowns() {
        return this.playerQuestCooldowns;
    }

    @Generated
    public void setPlayerQuestCooldowns(PlayerQuestCooldowns playerQuestCooldowns) {
        this.playerQuestCooldowns = playerQuestCooldowns;
    }

    @Generated
    public Location getBackTeleportLocation() {
        return this.backTeleportLocation;
    }

    @Generated
    public void setBackTeleportLocation(Location backTeleportLocation) {
        this.backTeleportLocation = backTeleportLocation;
    }

    @Generated
    public boolean isUseBookMenus() {
        return this.useBookMenus;
    }

    @Generated
    public void setUseBookMenus(boolean useBookMenus) {
        this.useBookMenus = useBookMenus;
    }

    @Generated
    public boolean isDismissEMStatusScreenMessage() {
        return this.dismissEMStatusScreenMessage;
    }

    @Generated
    public void setDismissEMStatusScreenMessage(boolean dismissEMStatusScreenMessage) {
        this.dismissEMStatusScreenMessage = dismissEMStatusScreenMessage;
    }

    @Generated
    public MatchInstance getMatchInstance() {
        return this.matchInstance;
    }

    @Generated
    public void setMatchInstance(MatchInstance matchInstance) {
        this.matchInstance = matchInstance;
    }

    @Generated
    public DungeonBossLockout getDungeonBossLockout() {
        return this.dungeonBossLockout;
    }

    @Generated
    public void setDungeonBossLockout(DungeonBossLockout dungeonBossLockout) {
        this.dungeonBossLockout = dungeonBossLockout;
    }

    @Generated
    public long getSkillXP_ARMOR() {
        return this.skillXP_ARMOR;
    }

    @Generated
    public void setSkillXP_ARMOR(long skillXP_ARMOR) {
        this.skillXP_ARMOR = skillXP_ARMOR;
    }

    @Generated
    public long getSkillXP_SWORDS() {
        return this.skillXP_SWORDS;
    }

    @Generated
    public void setSkillXP_SWORDS(long skillXP_SWORDS) {
        this.skillXP_SWORDS = skillXP_SWORDS;
    }

    @Generated
    public long getSkillXP_AXES() {
        return this.skillXP_AXES;
    }

    @Generated
    public void setSkillXP_AXES(long skillXP_AXES) {
        this.skillXP_AXES = skillXP_AXES;
    }

    @Generated
    public long getSkillXP_BOWS() {
        return this.skillXP_BOWS;
    }

    @Generated
    public void setSkillXP_BOWS(long skillXP_BOWS) {
        this.skillXP_BOWS = skillXP_BOWS;
    }

    @Generated
    public long getSkillXP_CROSSBOWS() {
        return this.skillXP_CROSSBOWS;
    }

    @Generated
    public void setSkillXP_CROSSBOWS(long skillXP_CROSSBOWS) {
        this.skillXP_CROSSBOWS = skillXP_CROSSBOWS;
    }

    @Generated
    public long getSkillXP_TRIDENTS() {
        return this.skillXP_TRIDENTS;
    }

    @Generated
    public void setSkillXP_TRIDENTS(long skillXP_TRIDENTS) {
        this.skillXP_TRIDENTS = skillXP_TRIDENTS;
    }

    @Generated
    public long getSkillXP_HOES() {
        return this.skillXP_HOES;
    }

    @Generated
    public void setSkillXP_HOES(long skillXP_HOES) {
        this.skillXP_HOES = skillXP_HOES;
    }

    @Generated
    public String getSkillBonusSelections() {
        return this.skillBonusSelections;
    }

    @Generated
    public void setSkillBonusSelections(String skillBonusSelections) {
        this.skillBonusSelections = skillBonusSelections;
    }

    public static class PlayerDataEvents
    implements Listener {
        @EventHandler(priority=EventPriority.LOWEST)
        public void onPlayerLogin(final PlayerJoinEvent event) {
            new BukkitRunnable(this){

                public void run() {
                    if (Bukkit.getPlayer((UUID)event.getPlayer().getUniqueId()) == null) {
                        return;
                    }
                    new PlayerData(event.getPlayer().getUniqueId());
                }
            }.runTaskLaterAsynchronously((Plugin)MetadataHandler.PLUGIN, 20L);
        }

        @EventHandler
        public void onPlayerLogout(final PlayerQuitEvent event) {
            new BukkitRunnable(this){

                public void run() {
                    PlayerData.clearPlayerData(event.getPlayer().getUniqueId());
                    PlayerData.setDisplayName(event.getPlayer().getUniqueId(), event.getPlayer().getName());
                }
            }.runTaskLaterAsynchronously((Plugin)MetadataHandler.PLUGIN, 20L);
        }
    }
}

