/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.npcs;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.PlayerPreTeleportEvent;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.menus.ArenaMenu;
import com.magmaguy.elitemobs.menus.CustomShopMenu;
import com.magmaguy.elitemobs.menus.EliteScrollMenu;
import com.magmaguy.elitemobs.menus.ItemEnchantmentMenu;
import com.magmaguy.elitemobs.menus.ProceduralShopMenu;
import com.magmaguy.elitemobs.menus.RepairMenu;
import com.magmaguy.elitemobs.menus.ScrapperMenu;
import com.magmaguy.elitemobs.menus.SellMenu;
import com.magmaguy.elitemobs.menus.SkillBonusMenu;
import com.magmaguy.elitemobs.menus.UnbindMenu;
import com.magmaguy.elitemobs.npcs.NPCEntity;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.quests.QuestInteractionHandler;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class NPCInteractions
implements Listener {
    private static final Set<UUID> cooldowns = new HashSet<UUID>();

    public static void shutdown() {
        cooldowns.clear();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void playerNPCInteract(final PlayerInteractAtEntityEvent event) {
        UUID playerUUID = event.getPlayer().getUniqueId();
        if (cooldowns.contains(playerUUID)) {
            return;
        }
        cooldowns.add(playerUUID);
        Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, () -> cooldowns.remove(playerUUID), 1L);
        if (event.isCancelled()) {
            return;
        }
        final NPCEntity npcEntity = EntityTracker.getNPCEntity(event.getRightClicked());
        if (npcEntity == null) {
            return;
        }
        if (event.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)Material.NAME_TAG)) {
            event.setCancelled(true);
            event.getPlayer().sendMessage("[EliteMobs] You can't rename NPCs using name tags!");
            return;
        }
        event.setCancelled(true);
        switch (npcEntity.getNPCsConfigFields().getInteractionType().ordinal()) {
            case 0: {
                if (!event.getPlayer().hasPermission("elitemobs.rank.npc")) break;
                new BukkitRunnable(this){

                    public void run() {
                        SkillBonusMenu.openWeaponSelectMenu(event.getPlayer());
                    }
                }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
                break;
            }
            case 1: {
                npcEntity.sayDialog(event.getPlayer());
                break;
            }
            case 2: {
                if (!event.getPlayer().hasPermission("elitemobs.shop.custom.npc")) break;
                new BukkitRunnable(this){

                    public void run() {
                        CustomShopMenu.customShopInitializer(event.getPlayer());
                    }
                }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
                break;
            }
            case 3: {
                if (!event.getPlayer().hasPermission("elitemobs.shop.dynamic.npc")) break;
                new BukkitRunnable(this){

                    public void run() {
                        ProceduralShopMenu.shopInitializer(event.getPlayer());
                    }
                }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
                break;
            }
            case 6: {
                if (!event.getPlayer().hasPermission("elitemobs.quest.npc")) break;
                new BukkitRunnable(this){

                    public void run() {
                        QuestInteractionHandler.processDynamicQuests(event.getPlayer(), npcEntity);
                    }
                }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
                break;
            }
            case 7: {
                QuestInteractionHandler.processNPCQuests(event.getPlayer(), npcEntity);
                break;
            }
            case 4: {
                event.getPlayer().sendMessage("[EliteMobs] This feature is coming soon!");
                break;
            }
            case 9: {
                if (!event.getPlayer().hasPermission("elitemobs.shop.sell.npc")) break;
                new BukkitRunnable(this){

                    public void run() {
                        SellMenu sellMenu = new SellMenu();
                        sellMenu.constructSellMenu(event.getPlayer());
                    }
                }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
                break;
            }
            case 10: {
                if (!event.getPlayer().hasPermission("elitemobs.back.npc")) break;
                Location previousLocation = PlayerData.getBackTeleportLocation(event.getPlayer());
                if (previousLocation == null) {
                    if (npcEntity.npCsConfigFields.noPreviousLocationMessage == null) break;
                    event.getPlayer().sendMessage(ChatColorConverter.convert(npcEntity.npCsConfigFields.noPreviousLocationMessage));
                    break;
                }
                PlayerPreTeleportEvent.teleportPlayer(event.getPlayer(), previousLocation);
                break;
            }
            case 11: {
                if (!event.getPlayer().hasPermission("elitemobs.scrap.npc")) break;
                new BukkitRunnable(this){

                    public void run() {
                        ScrapperMenu scrapperMenu = new ScrapperMenu();
                        scrapperMenu.constructScrapMenu(event.getPlayer());
                    }
                }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
                break;
            }
            case 13: {
                if (!event.getPlayer().hasPermission("elitemobs.repair.npc")) break;
                new BukkitRunnable(this){

                    public void run() {
                        RepairMenu repairMenu = new RepairMenu();
                        repairMenu.constructRepairMenu(event.getPlayer());
                    }
                }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
                break;
            }
            case 16: {
                if (!event.getPlayer().hasPermission("elitemobs.unbind.npc")) break;
                new BukkitRunnable(this){

                    public void run() {
                        UnbindMenu unbindMenu = new UnbindMenu();
                        unbindMenu.constructUnbinderMenu(event.getPlayer());
                    }
                }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
                break;
            }
            case 17: {
                new BukkitRunnable(this){

                    public void run() {
                        ArenaMenu arenaMenu = new ArenaMenu();
                        arenaMenu.constructArenaMenu(event.getPlayer(), npcEntity.getNPCsConfigFields().getArenaFilename());
                    }
                }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
                break;
            }
            default: {
                break;
            }
            case 18: {
                if (npcEntity.getNPCsConfigFields().getCommand() == null) {
                    Logger.warn("Failed to run NPC command because none is configured for " + npcEntity.getNPCsConfigFields().getFilename());
                    return;
                }
                new BukkitRunnable(this){

                    public void run() {
                        event.getPlayer().performCommand(npcEntity.getNPCsConfigFields().getCommand());
                    }
                }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                event.getPlayer().sendMessage(ChatColorConverter.convert("&8[EliteMobs] &cThis feature has been replaced! This NPC should be removed by an admin as soon as possible."));
                if (!event.getPlayer().isOp() && !event.getPlayer().hasPermission("elitemobs.*")) break;
                event.getPlayer().sendMessage(ChatColorConverter.convert("&2To remove this NPC, use the command &6/em remove &2and hit the NPC!"));
                break;
            }
            case 19: {
                if (!event.getPlayer().hasPermission("elitemobs.enchant.npc")) break;
                new BukkitRunnable(this){

                    public void run() {
                        new ItemEnchantmentMenu(event.getPlayer());
                    }
                }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
                break;
            }
            case 20: {
                if (!event.getPlayer().hasPermission("elitemobs.scroll.npc")) break;
                new BukkitRunnable(this){

                    public void run() {
                        new EliteScrollMenu(event.getPlayer());
                    }
                }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
            }
        }
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (!event.getInventory().getType().equals((Object)InventoryType.MERCHANT)) {
            return;
        }
        for (NPCEntity npcEntity : EntityTracker.getNpcEntities().values()) {
            if (!event.getView().getTitle().equals(npcEntity.getNPCsConfigFields().getName())) continue;
            event.setCancelled(true);
            return;
        }
    }

    public static enum NPCInteractionType {
        GUILD_GREETER,
        CHAT,
        CUSTOM_SHOP,
        PROCEDURALLY_GENERATED_SHOP,
        BAR,
        ARENA,
        QUEST_GIVER,
        CUSTOM_QUEST_GIVER,
        NONE,
        SELL,
        TELEPORT_BACK,
        SCRAPPER,
        SMELTER,
        REPAIRMAN,
        ENHANCER,
        REFINER,
        UNBINDER,
        ARENA_MASTER,
        COMMAND,
        ENCHANTER,
        SCROLL_APPLIER;

    }
}

