/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.mobconstructor.custombosses;

import com.magmaguy.elitemobs.EliteMobs;
import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfigFields;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.RegionalBossEntity;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import com.magmaguy.elitemobs.thirdparty.custommodels.CustomModel;
import com.magmaguy.elitemobs.thirdparty.libsdisguises.DisguiseEntity;
import com.magmaguy.elitemobs.thirdparty.worldguard.WorldGuardFlagChecker;
import com.magmaguy.elitemobs.thirdparty.worldguard.WorldGuardSpawnEventBypasser;
import com.magmaguy.magmacore.util.AttributeManager;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Slime;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.meta.ItemMeta;

public class CustomBossMegaConsumer {
    private final CustomBossesConfigFields customBossesConfigFields;
    private final HashSet<ElitePower> powers;
    private final int level;
    private final boolean bypassesWorldGuardSpawn;
    private final Location spawnLocation;
    CustomBossEntity customBossEntity;

    public CustomBossMegaConsumer(CustomBossEntity customBossEntity) {
        this.customBossesConfigFields = customBossEntity.getCustomBossesConfigFields();
        this.customBossEntity = customBossEntity;
        if (customBossEntity.getRespawnOverrideLocation() != null) {
            this.spawnLocation = customBossEntity.getRespawnOverrideLocation();
            customBossEntity.setRespawnOverrideLocation(null);
        } else {
            this.spawnLocation = customBossEntity.getSpawnLocation();
        }
        this.powers = customBossEntity.getElitePowers();
        this.level = customBossEntity.getLevel();
        this.bypassesWorldGuardSpawn = customBossEntity.getBypassesProtections();
    }

    protected static void setName(LivingEntity livingEntity, CustomBossEntity customBossEntity, int level) {
        String parsedName = ChatColorConverter.convert(customBossEntity.customBossesConfigFields.getName().replace("$level", "" + level).replace("$normalLevel", ChatColorConverter.convert("&2[&a" + level + "&2]&f")).replace("$minibossLevel", ChatColorConverter.convert("&6\u3016&e" + level + "&6\u3017&f")).replace("$bossLevel", ChatColorConverter.convert("&4\u300e&c" + level + "&4\u300f&f")).replace("$reinforcementLevel", ChatColorConverter.convert("&8\u3014&7") + level + "&8\u3015&f").replace("$eventBossLevel", ChatColorConverter.convert("&4\u300c&c" + level + "&4\u300d&f")));
        livingEntity.setCustomName(parsedName);
        livingEntity.setCustomNameVisible(DefaultConfig.isAlwaysShowNametags());
        if (Bukkit.getPluginManager().isPluginEnabled("LibsDisguises")) {
            DisguiseEntity.setDisguiseNameVisibility(DefaultConfig.isAlwaysShowNametags(), (Entity)livingEntity, parsedName);
        }
        customBossEntity.setName(parsedName, false);
    }

    public LivingEntity spawn() {
        if (this.spawnLocation == null) {
            Logger.warn("Custom Boss Entity " + this.customBossesConfigFields.getFilename() + " tried to spawn without a valid spawn location getting assigned! Report this to the developer!");
            return null;
        }
        if (EliteMobs.worldGuardIsEnabled) {
            if (!WorldGuardFlagChecker.doEliteMobsSpawnFlag(this.spawnLocation)) {
                Logger.warn("Attempted to spawn " + this.customBossesConfigFields.getFilename() + " in location " + String.valueOf(this.spawnLocation) + " which is protected by WorldGuard with elitemobs-spawning deny! This should not have happened.");
                return null;
            }
            if (this.bypassesWorldGuardSpawn || this.customBossEntity instanceof RegionalBossEntity) {
                WorldGuardSpawnEventBypasser.forceSpawn();
            }
        }
        LivingEntity livingEntity = (LivingEntity)this.spawnLocation.getWorld().spawn(this.spawnLocation, this.customBossesConfigFields.getEntityType().getEntityClass(), entity -> this.applyBossFeatures((LivingEntity)entity));
        this.setCustomModel(livingEntity);
        this.customBossEntity.setLivingEntity(livingEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return livingEntity;
    }

    private void setBaby(LivingEntity livingEntity) {
        if (livingEntity instanceof Ageable) {
            if (this.customBossesConfigFields.isBaby()) {
                ((Ageable)livingEntity).setBaby();
            } else {
                ((Ageable)livingEntity).setAdult();
            }
        }
    }

    private void setDisguise(LivingEntity livingEntity) {
        if (this.customBossesConfigFields.getDisguise() == null || CustomModel.customModelsEnabled() && this.customBossesConfigFields.isCustomModelExists() && this.customBossesConfigFields.getCustomModel() != null && !this.customBossesConfigFields.getCustomModel().isEmpty()) {
            return;
        }
        if (!Bukkit.getPluginManager().isPluginEnabled("LibsDisguises")) {
            return;
        }
        try {
            DisguiseEntity.disguise(this.customBossesConfigFields.getDisguise(), (Entity)livingEntity, this.customBossesConfigFields.getCustomDisguiseData(), this.customBossesConfigFields.getFilename());
        }
        catch (Exception ex) {
            Logger.warn("Failed to load LibsDisguises disguise correctly!");
        }
    }

    private void setCustomModel(LivingEntity livingEntity) {
        if (!this.customBossesConfigFields.isCustomModelExists()) {
            return;
        }
        if (this.customBossesConfigFields.getCustomModel() == null || this.customBossesConfigFields.getCustomModel().isEmpty()) {
            return;
        }
        try {
            this.customBossEntity.setCustomModel(CustomModel.generateCustomModel(livingEntity, this.customBossesConfigFields.getCustomModel(), this.customBossEntity.getName()));
        }
        catch (Exception exception) {
            this.customBossEntity.setCustomModel(null);
            Logger.warn("Failed to initialize Custom Model for Custom Boss " + this.customBossesConfigFields.getFilename());
            exception.printStackTrace();
        }
    }

    private void setFrozen(LivingEntity livingEntity) {
        if (!this.customBossesConfigFields.isFrozen()) {
            return;
        }
        AttributeManager.setAttribute(livingEntity, "generic_movement_speed", 0.0);
    }

    private void setEquipment(LivingEntity livingEntity) {
        try {
            ItemMeta helmetMeta;
            livingEntity.getEquipment().setHelmet(this.customBossesConfigFields.getHelmet());
            livingEntity.getEquipment().setChestplate(this.customBossesConfigFields.getChestplate());
            livingEntity.getEquipment().setLeggings(this.customBossesConfigFields.getLeggings());
            livingEntity.getEquipment().setBoots(this.customBossesConfigFields.getBoots());
            livingEntity.getEquipment().setItemInMainHand(this.customBossesConfigFields.getMainHand());
            livingEntity.getEquipment().setItemInOffHand(this.customBossesConfigFields.getOffHand());
            if (livingEntity.getEquipment().getHelmet() != null && (helmetMeta = livingEntity.getEquipment().getHelmet().getItemMeta()) != null) {
                helmetMeta.setUnbreakable(true);
                livingEntity.getEquipment().getHelmet().setItemMeta(helmetMeta);
            }
        }
        catch (Exception ex) {
            Logger.warn("Tried to assign a material slot to an invalid entity! Boss is from file" + this.customBossesConfigFields.getFilename());
        }
    }

    public void applyBossFeatures(LivingEntity livingEntity) {
        for (ElitePower elitePower : this.powers) {
            elitePower.applyPowers(livingEntity);
        }
        this.setEquipment(livingEntity);
        this.setBaby(livingEntity);
        this.setDisguise(livingEntity);
        CustomBossMegaConsumer.setName(livingEntity, this.customBossEntity, this.level);
        this.setFollowRange(livingEntity);
        this.setMovementSpeed(livingEntity);
        this.setFrozen(livingEntity);
        this.setScale(livingEntity);
        this.setSilent(livingEntity);
        this.customBossEntity.setMovementSpeedAttribute(AttributeManager.getAttributeBaseValue(livingEntity, "generic_movement_speed"));
        this.customBossEntity.setFollowDistance(AttributeManager.getAttributeBaseValue(livingEntity, "generic_follow_range"));
        if (livingEntity.getType().equals((Object)EntityType.ENDER_DRAGON)) {
            ((EnderDragon)livingEntity).setPhase(EnderDragon.Phase.CIRCLING);
            if (((EnderDragon)livingEntity).getDragonBattle() != null) {
                ((EnderDragon)livingEntity).getDragonBattle().generateEndPortal(false);
            }
        }
        if (livingEntity instanceof Slime) {
            ((Slime)livingEntity).setSize(this.customBossEntity.getCustomBossesConfigFields().getSlimeSize());
        }
        this.customBossEntity.setUnsyncedLivingEntity(livingEntity);
        EntityTracker.registerEliteMob(this.customBossEntity, livingEntity);
    }

    private void setFollowRange(LivingEntity livingEntity) {
        if (this.customBossesConfigFields.getFollowDistance() != null && this.customBossesConfigFields.getFollowDistance() > 0 && livingEntity instanceof Mob) {
            AttributeManager.setAttribute(livingEntity, "generic_follow_range", this.customBossesConfigFields.getFollowDistance().intValue());
        }
    }

    private void setMovementSpeed(LivingEntity livingEntity) {
        if (this.customBossesConfigFields.getMovementSpeedAttribute() != null) {
            AttributeManager.setAttribute(livingEntity, "generic_movement_speed", this.customBossesConfigFields.getMovementSpeedAttribute());
        }
    }

    private void setScale(LivingEntity livingEntity) {
        if (this.customBossesConfigFields.getScale() != 1.0) {
            AttributeManager.setAttribute(livingEntity, "generic_scale", this.customBossesConfigFields.getScale());
        }
    }

    private void setSilent(LivingEntity livingEntity) {
        if (this.customBossesConfigFields.isSilent()) {
            livingEntity.setSilent(true);
        }
    }
}

