/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.mobconstructor;

import com.google.common.collect.ArrayListMultimap;
import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.InstancedDungeonRemoveEvent;
import com.magmaguy.elitemobs.mobconstructor.PersistentMovingEntity;
import com.magmaguy.elitemobs.mobconstructor.PersistentObject;
import com.magmaguy.elitemobs.utils.ChunkVectorizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;

public class PersistentObjectHandler {
    private static final ArrayListMultimap<String, PersistentObjectHandler> persistentObjects = ArrayListMultimap.create();
    private final PersistentObject persistentObject;
    private final String worldName;
    private Location persistentLocation;
    private String chunk;

    public PersistentObjectHandler(PersistentObject persistentObject) {
        this.persistentObject = persistentObject;
        this.persistentLocation = persistentObject.getPersistentLocation();
        this.worldName = persistentObject.getWorldName();
        if (this.persistentLocation != null && this.persistentLocation.getWorld() != null && Bukkit.getWorld((UUID)this.persistentLocation.getWorld().getUID()) != null) {
            this.addChunkKey(this);
        } else {
            this.addWorldKey(this);
        }
    }

    public static void shutdown() {
        persistentObjects.clear();
    }

    private void addChunkKey(PersistentObjectHandler simplePersistentEntity) {
        if (this.persistentLocation.getWorld() == null) {
            return;
        }
        this.chunk = "" + ChunkVectorizer.hash(this.persistentLocation.getBlockX() >> 4, this.persistentLocation.getBlockZ() >> 4, this.persistentLocation.getWorld().getUID());
        persistentObjects.put((Object)simplePersistentEntity.chunk, (Object)simplePersistentEntity);
    }

    private void addWorldKey(PersistentObjectHandler persistentObjectHandler) {
        persistentObjects.put((Object)persistentObjectHandler.worldName, (Object)persistentObjectHandler);
    }

    public void worldLoad(World world) {
        this.persistentObject.worldLoad(world);
        this.remove();
        this.persistentLocation.setWorld(world);
        this.addChunkKey(this);
    }

    public void worldUnload() {
        this.persistentObject.worldUnload();
        this.remove();
        this.addWorldKey(this);
    }

    public void updatePersistentLocation(Location location) {
        this.remove();
        this.persistentLocation = location;
        this.addChunkKey(this);
    }

    public void remove() {
        persistentObjects.remove((Object)this.chunk, (Object)this);
        persistentObjects.remove((Object)this.worldName, (Object)this);
    }

    @Generated
    public Location getPersistentLocation() {
        return this.persistentLocation;
    }

    public static class PersistentObjectHandlerEvents
    implements Listener {
        private static int chunkLocation(Chunk chunk) {
            return ChunkVectorizer.hash(chunk);
        }

        private static void loadChunk(List<PersistentObjectHandler> persistentObjectHandlers) {
            persistentObjectHandlers.forEach(persistentObjectHandler -> persistentObjectHandler.persistentObject.chunkLoad());
        }

        private static void unloadChunk(List<PersistentObjectHandler> persistentObjectHandlers) {
            persistentObjectHandlers.forEach(persistentObjectHandler -> {
                if (persistentObjectHandler.persistentObject instanceof PersistentMovingEntity) {
                    return;
                }
                persistentObjectHandler.persistentObject.chunkUnload();
            });
        }

        private static void unloadWorld(World world) {
            ArrayList<PersistentObjectHandler> copy = new ArrayList<PersistentObjectHandler>();
            for (PersistentObjectHandler persistentObjectHandler : persistentObjects.values()) {
                if (!Objects.equals(persistentObjectHandler.worldName, world.getName())) continue;
                copy.add(persistentObjectHandler);
            }
            copy.forEach(PersistentObjectHandler::worldUnload);
        }

        private static void loadWorld(World world) {
            ArrayList copy = new ArrayList(persistentObjects.get((Object)world.getName()));
            copy.forEach(persistentObjectHandler -> persistentObjectHandler.worldLoad(world));
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
        public void chunkLoadEvent(ChunkLoadEvent event) {
            int chunkLocation = PersistentObjectHandlerEvents.chunkLocation(event.getChunk());
            ArrayList simplePersistentEntityList = new ArrayList(persistentObjects.get((Object)("" + chunkLocation)));
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MetadataHandler.PLUGIN, () -> PersistentObjectHandlerEvents.loadChunk(simplePersistentEntityList), 1L);
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
        public void worldUnloadEvent(WorldUnloadEvent event) {
            PersistentObjectHandlerEvents.unloadWorld(event.getWorld());
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        public void worldLoadEvent(WorldLoadEvent event) {
            PersistentObjectHandlerEvents.loadWorld(event.getWorld());
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void chunkUnloadEvent(ChunkUnloadEvent event) {
            int chunkLocation = PersistentObjectHandlerEvents.chunkLocation(event.getChunk());
            ArrayList<PersistentObjectHandler> simplePersistentEntityList = new ArrayList<PersistentObjectHandler>(persistentObjects.get((Object)("" + chunkLocation)));
            PersistentObjectHandlerEvents.unloadChunk(simplePersistentEntityList);
        }

        @EventHandler
        public void onInstanceRemove(InstancedDungeonRemoveEvent event) {
            persistentObjects.removeAll((Object)event.getDungeonInstance().getInstancedWorldName());
        }
    }
}

