/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.menus;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class EliteMenu
implements Listener {
    public static void createEliteMenu(Inventory inventory, Set<Inventory> inventories) {
        inventories.add(inventory);
    }

    public static boolean isEliteMenu(InventoryClickEvent event, Set<Inventory> inventories) {
        return inventories.contains(event.getInventory());
    }

    public static boolean isTopMenu(InventoryClickEvent event) {
        if (event.getClickedInventory() == null) {
            return false;
        }
        return event.getClickedInventory().equals((Object)event.getView().getTopInventory());
    }

    public static boolean isBottomMenu(InventoryClickEvent event) {
        return !EliteMenu.isTopMenu(event);
    }

    public static void cancel(HumanEntity player, Inventory eliteInventory, Inventory playerInventory, List<Integer> inputSlots) {
        for (int slot : inputSlots) {
            if (eliteInventory.getItem(slot) == null) continue;
            HashMap leftOvers = playerInventory.addItem(new ItemStack[]{eliteInventory.getItem(slot)});
            eliteInventory.clear(slot);
            if (leftOvers.isEmpty()) continue;
            leftOvers.values().forEach(itemStack -> player.getWorld().dropItem(player.getLocation(), itemStack));
        }
    }

    public static void moveOneItemUp(int targetSlot, InventoryClickEvent event) {
        if (event.getCurrentItem() == null) {
            return;
        }
        ItemStack newItemStack = event.getCurrentItem().clone();
        newItemStack.setAmount(1);
        event.getView().getTopInventory().setItem(targetSlot, newItemStack);
        event.getCurrentItem().setAmount(event.getCurrentItem().getAmount() - 1);
    }

    public static boolean moveItemDown(Inventory inventoryToClear, int slotToClear, HumanEntity player, boolean canDrop) {
        boolean itemLoss = false;
        if (inventoryToClear.getItem(slotToClear) == null) {
            return itemLoss;
        }
        HashMap leftovers = player.getInventory().addItem(new ItemStack[]{inventoryToClear.getItem(slotToClear)});
        if (!leftovers.isEmpty() && canDrop) {
            player.getWorld().dropItem(player.getLocation(), inventoryToClear.getItem(slotToClear));
        } else if (!leftovers.isEmpty()) {
            itemLoss = true;
        }
        inventoryToClear.setItem(slotToClear, null);
        return itemLoss;
    }

    public static void moveItemDown(Inventory inventoryToClear, int slotToClear, HumanEntity player) {
        EliteMenu.moveItemDown(inventoryToClear, slotToClear, player, true);
    }
}

