/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.menus;

import com.magmaguy.elitemobs.config.DungeonsConfig;
import com.magmaguy.elitemobs.dungeons.DynamicDungeonPackage;
import com.magmaguy.elitemobs.dungeons.EMPackage;
import com.magmaguy.elitemobs.instanced.MatchInstance;
import com.magmaguy.elitemobs.instanced.dungeons.DungeonInstance;
import com.magmaguy.elitemobs.instanced.dungeons.DynamicDungeonInstance;
import com.magmaguy.elitemobs.menus.EliteMenu;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class DynamicDungeonBrowser
extends EliteMenu {
    private static final HashMap<Inventory, DynamicDungeonBrowser> inventories = new HashMap();
    private final EMPackage emPackage;
    private final MenuType menuType;
    private final List<Integer> levelSlots = List.of(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(6), Integer.valueOf(0), Integer.valueOf(8), Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(5), Integer.valueOf(7));
    private final List<Integer> difficultySlots = List.of(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(6), Integer.valueOf(0), Integer.valueOf(8), Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(5), Integer.valueOf(7));
    private final List<Integer> validSlots = new ArrayList<Integer>(List.of(18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53));
    private Integer selectedLevel = null;
    private List<DynamicDungeonInstance> instancesList = new ArrayList<DynamicDungeonInstance>();

    public static void shutdown() {
        inventories.clear();
    }

    public DynamicDungeonBrowser(Player player, String dynamicDungeonName) {
        this(player, dynamicDungeonName, MenuType.LEVEL_SELECTION, null);
    }

    private DynamicDungeonBrowser(Player player, String dynamicDungeonName, MenuType menuType, Integer selectedLevel) {
        EMPackage emPackage;
        this.emPackage = emPackage = EMPackage.getEmPackages().get(dynamicDungeonName);
        this.menuType = menuType;
        this.selectedLevel = selectedLevel;
        if (!(emPackage instanceof DynamicDungeonPackage)) {
            player.sendMessage("[EliteMobs] Not a valid dynamic dungeon!");
            return;
        }
        if (menuType == MenuType.LEVEL_SELECTION) {
            this.showLevelSelectionMenu(player, dynamicDungeonName);
        } else {
            this.showDifficultySelectionMenu(player, dynamicDungeonName);
        }
    }

    private void showLevelSelectionMenu(Player player, String dynamicDungeonName) {
        int i;
        int baseLevel = 50;
        int minLevel = Math.max(5, baseLevel - 5);
        int maxLevel = Math.min(200, baseLevel + 5);
        ArrayList<Integer> availableLevels = new ArrayList<Integer>();
        for (int level = minLevel; level <= maxLevel; level += 5) {
            availableLevels.add(level);
        }
        this.instancesList = DungeonInstance.getDungeonInstances().stream().filter(instance -> instance instanceof DynamicDungeonInstance).filter(instance -> instance.getContentPackagesConfigFields().getFilename().equals(dynamicDungeonName)).map(instance -> (DynamicDungeonInstance)instance).collect(Collectors.toList());
        int slots = this.instancesList.isEmpty() ? 9 : 54;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (int)slots, (String)ChatColorConverter.convert(DungeonsConfig.getDynamicDungeonLevelSelectionMenuTitle()));
        for (i = 0; i < availableLevels.size() && i < this.levelSlots.size(); ++i) {
            Material material;
            int level = (Integer)availableLevels.get(i);
            ArrayList<String> description = new ArrayList<String>();
            description.add(ChatColorConverter.convert(DungeonsConfig.getDynamicDungeonLevelSelectionClickToSelect().replace("$level", String.valueOf(level))));
            description.add(ChatColorConverter.convert(DungeonsConfig.getDynamicDungeonLevelSelectionMobsWillBeLevel().replace("$level", String.valueOf(level))));
            if (level == baseLevel) {
                material = Material.LIME_STAINED_GLASS_PANE;
                description.add(ChatColorConverter.convert(DungeonsConfig.getDynamicDungeonLevelSelectionRecommended()));
            } else if (level < baseLevel) {
                material = Material.YELLOW_STAINED_GLASS_PANE;
                description.add(ChatColorConverter.convert(DungeonsConfig.getDynamicDungeonLevelSelectionEasier()));
            } else {
                material = Material.ORANGE_STAINED_GLASS_PANE;
                description.add(ChatColorConverter.convert(DungeonsConfig.getDynamicDungeonLevelSelectionHarder()));
            }
            inventory.setItem(this.levelSlots.get(i).intValue(), ItemStackGenerator.generateItemStack(material, ChatColorConverter.convert(DungeonsConfig.getDynamicDungeonLevelSelectionItemTitle().replace("$level", String.valueOf(level))), description));
        }
        for (i = 0; i < this.instancesList.size() && i < this.validSlots.size(); ++i) {
            DynamicDungeonInstance instance2 = this.instancesList.get(i);
            ItemStack itemStack = null;
            if (instance2.getState().equals((Object)MatchInstance.InstancedRegionState.WAITING)) {
                itemStack = this.playerItem(instance2);
            } else if (DungeonsConfig.isAllowSpectatorsInInstancedContent()) {
                itemStack = this.spectatorItem(instance2);
            }
            if (itemStack == null) continue;
            inventory.setItem(this.validSlots.get(i).intValue(), itemStack);
        }
        player.openInventory(inventory);
        inventories.put(inventory, this);
    }

    private ItemStack spectatorItem(DynamicDungeonInstance dungeonInstance) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(ChatColorConverter.convert("&7Level: &e" + dungeonInstance.getSelectedLevel()));
        lore.add(ChatColorConverter.convert("&2Players:"));
        dungeonInstance.getPlayers().forEach(player -> lore.add(ChatColorConverter.convert("&f- " + player.getDisplayName())));
        return ItemStackGenerator.generateItemStack(Material.ORANGE_STAINED_GLASS_PANE, DungeonsConfig.getDungeonJoinAsSpectatorText().replace("$dungeonName", dungeonInstance.getContentPackagesConfigFields().getName()), lore);
    }

    private ItemStack playerItem(DynamicDungeonInstance dungeonInstance) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(ChatColorConverter.convert("&7Level: &e" + dungeonInstance.getSelectedLevel()));
        lore.add(ChatColorConverter.convert("&2Players:"));
        dungeonInstance.getPlayers().forEach(player -> lore.add(ChatColorConverter.convert("&f- " + player.getDisplayName())));
        return ItemStackGenerator.generateItemStack(Material.GREEN_STAINED_GLASS_PANE, DungeonsConfig.getDungeonJoinAsPlayerText().replace("$dungeonName", dungeonInstance.getContentPackagesConfigFields().getName()), lore);
    }

    private void showDifficultySelectionMenu(Player player, String dynamicDungeonName) {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (int)9, (String)ChatColorConverter.convert(DungeonsConfig.getDynamicDungeonDifficultySelectionMenuTitle()));
        int difficultyCounter = 0;
        for (Map<String, Object> map : this.emPackage.getContentPackagesConfigFields().getDifficulties()) {
            ArrayList<String> description = new ArrayList<String>();
            for (String string : DungeonsConfig.getInstancedDungeonDescription()) {
                description.add(string.replace("$dungeonName", this.emPackage.getContentPackagesConfigFields().getName()));
            }
            description.add(ChatColorConverter.convert(DungeonsConfig.getDynamicDungeonDifficultySelectionSelectedLevel().replace("$level", String.valueOf(this.selectedLevel))));
            inventory.setItem(this.difficultySlots.get(difficultyCounter).intValue(), ItemStackGenerator.generateItemStack(Material.GREEN_STAINED_GLASS_PANE, DungeonsConfig.getInstancedDungeonTitle().replace("$difficulty", String.valueOf(map.get("name"))), description));
            ++difficultyCounter;
        }
        player.openInventory(inventory);
        inventories.put(inventory, this);
    }

    @Generated
    public EMPackage getEmPackage() {
        return this.emPackage;
    }

    private static enum MenuType {
        LEVEL_SELECTION,
        DIFFICULTY_SELECTION;

    }

    public static class DynamicDungeonBrowserEvents
    implements Listener {
        @EventHandler
        public void onInventoryInteract(InventoryClickEvent event) {
            if (!EliteMenu.isEliteMenu(event, inventories.keySet())) {
                return;
            }
            event.setCancelled(true);
            if (!EliteMenu.isTopMenu(event)) {
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getType().equals((Object)Material.AIR)) {
                return;
            }
            DynamicDungeonBrowser browser = inventories.get(event.getInventory());
            Player player = (Player)event.getWhoClicked();
            event.getWhoClicked().closeInventory();
            if (browser.menuType == MenuType.LEVEL_SELECTION) {
                int instanceIndex;
                if (browser.levelSlots.contains(event.getSlot())) {
                    int levelIndex = browser.levelSlots.indexOf(event.getSlot());
                    int baseLevel = 50;
                    int minLevel = Math.max(5, baseLevel - 5);
                    int selectedLevel = minLevel + levelIndex * 5;
                    new DynamicDungeonBrowser(player, browser.getEmPackage().getContentPackagesConfigFields().getFilename(), MenuType.DIFFICULTY_SELECTION, selectedLevel);
                } else if (browser.validSlots.contains(event.getSlot()) && (instanceIndex = browser.validSlots.indexOf(event.getSlot())) < browser.instancesList.size()) {
                    DynamicDungeonInstance dungeonInstance = browser.instancesList.get(instanceIndex);
                    switch (dungeonInstance.getState()) {
                        case ONGOING: 
                        case STARTING: {
                            if (!DungeonsConfig.isAllowSpectatorsInInstancedContent()) break;
                            dungeonInstance.addSpectator(player, false);
                            break;
                        }
                        case WAITING: {
                            dungeonInstance.addNewPlayer(player);
                            break;
                        }
                        case COMPLETED: 
                        case COMPLETED_VICTORY: 
                        case COMPLETED_DEFEAT: {
                            player.sendMessage("[EliteMobs] This match already ended! Can't join it!");
                        }
                    }
                }
            } else if (browser.menuType == MenuType.DIFFICULTY_SELECTION && browser.difficultySlots.contains(event.getSlot())) {
                String difficultyName = (String)browser.getEmPackage().getContentPackagesConfigFields().getDifficulties().get(browser.difficultySlots.indexOf(event.getSlot())).get("name");
                DynamicDungeonInstance.setupDynamicDungeon(player, browser.getEmPackage().getContentPackagesConfigFields().getFilename(), difficultyName, browser.selectedLevel);
            }
        }

        @EventHandler
        public void onClose(InventoryCloseEvent event) {
            inventories.remove(event.getInventory());
        }
    }
}

