/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.menus;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.CustomModelsConfig;
import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.EconomySettingsConfig;
import com.magmaguy.elitemobs.config.menus.premade.BuyOrSellMenuConfig;
import com.magmaguy.elitemobs.config.menus.premade.CustomShopMenuConfig;
import com.magmaguy.elitemobs.economy.EconomyHandler;
import com.magmaguy.elitemobs.items.EliteItemLore;
import com.magmaguy.elitemobs.items.ItemTagger;
import com.magmaguy.elitemobs.items.ItemWorthCalculator;
import com.magmaguy.elitemobs.items.customenchantments.SoulbindEnchantment;
import com.magmaguy.elitemobs.items.customitems.CustomItem;
import com.magmaguy.elitemobs.menus.BuyOrSellMenu;
import com.magmaguy.elitemobs.menus.EliteMenu;
import com.magmaguy.elitemobs.menus.SharedShopElements;
import com.magmaguy.elitemobs.utils.CustomModelAdder;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CustomShopMenu {
    public static Set<UUID> cooldownPlayers = new HashSet<UUID>();

    public static void shutdown() {
        cooldownPlayers.clear();
        CustomShopMenuEvents.menus.clear();
    }

    public static void customShopInitializer(Player player) {
        if (!EconomySettingsConfig.isEnableEconomy()) {
            return;
        }
        BuyOrSellMenu.constructBuyOrSellMenu(player, BuyOrSellMenuConfig.BUY_CUSTOM_ITEM);
    }

    public static void customShopConstructor(Player player) {
        Object menuName = CustomShopMenuConfig.shopName;
        if (DefaultConfig.useResourcePackModels()) {
            menuName = String.valueOf(ChatColor.WHITE) + "\uf801\udb80\udc8b\uf805          " + (String)menuName;
        }
        Inventory shopInventory = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)menuName);
        CustomShopMenu.populateShop(shopInventory, player);
        player.openInventory(shopInventory);
        CustomShopMenuEvents.menus.add(shopInventory);
    }

    private static void populateShop(Inventory shopInventory, Player player) {
        ItemStack rerollButton = CustomShopMenuConfig.rerollItem;
        if (DefaultConfig.useResourcePackModels()) {
            rerollButton.setType(Material.PAPER);
            CustomModelAdder.addCustomModel(rerollButton, CustomModelsConfig.goldenQuestionMark);
        }
        shopInventory.setItem(CustomShopMenuConfig.rerollSlot, rerollButton);
        CustomShopMenu.shopContents(shopInventory, player);
    }

    private static void shopContents(Inventory shopInventory, Player player) {
        Random random = new Random();
        for (int i : CustomShopMenuConfig.storeSlots) {
            int itemEntryIndex = random.nextInt(CustomItem.getCustomItemStackShopList().size());
            ItemStack itemStack = CustomItem.getCustomItemStackShopList().get(itemEntryIndex).clone();
            SoulbindEnchantment.addEnchantment(itemStack, player);
            new EliteItemLore(itemStack, true);
            shopInventory.setItem(i, itemStack);
        }
    }

    public static class CustomShopMenuEvents
    implements Listener {
        public static HashSet<Inventory> menus = new HashSet();

        @EventHandler
        public void onClick(final InventoryClickEvent event) {
            if (!EliteMenu.isEliteMenu(event, menus)) {
                return;
            }
            event.setCancelled(true);
            if (!SharedShopElements.itemNullPointerPrevention(event)) {
                return;
            }
            if (event.getCurrentItem().getItemMeta().getDisplayName().equals(CustomShopMenuConfig.rerollItem.getItemMeta().getDisplayName())) {
                if (cooldownPlayers.contains(event.getWhoClicked().getUniqueId())) {
                    event.setCancelled(true);
                    return;
                }
                cooldownPlayers.add(event.getWhoClicked().getUniqueId());
                new BukkitRunnable(this){

                    public void run() {
                        cooldownPlayers.remove(event.getWhoClicked().getUniqueId());
                    }
                }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 40L);
                CustomShopMenu.populateShop(event.getInventory(), Bukkit.getPlayer((UUID)event.getWhoClicked().getUniqueId()));
                event.setCancelled(true);
                return;
            }
            if (!ItemTagger.isEliteItem(event.getCurrentItem())) {
                event.setCancelled(true);
                return;
            }
            Player player = (Player)event.getWhoClicked();
            ItemStack itemStack = event.getCurrentItem();
            String itemDisplayName = event.getCurrentItem().getItemMeta().getDisplayName();
            double itemValue = ItemWorthCalculator.determineItemWorth(itemStack, player);
            boolean inventoryHasFreeSlots = false;
            for (ItemStack iteratedStack : player.getInventory().getStorageContents()) {
                if (iteratedStack != null) continue;
                inventoryHasFreeSlots = true;
                break;
            }
            if (EliteMenu.isTopMenu(event)) {
                if (!inventoryHasFreeSlots) {
                    player.sendMessage(CustomShopMenuConfig.messageFullInventory);
                    player.closeInventory();
                } else if (EconomyHandler.checkCurrency(player.getUniqueId()) >= itemValue) {
                    EconomyHandler.subtractCurrency(player.getUniqueId(), itemValue);
                    new EliteItemLore(itemStack, false);
                    player.getInventory().addItem(new ItemStack[]{itemStack});
                    CustomShopMenu.populateShop(event.getInventory(), Bukkit.getPlayer((UUID)event.getWhoClicked().getUniqueId()));
                    SharedShopElements.buyMessage(player, itemDisplayName, itemValue);
                } else {
                    player.closeInventory();
                    SharedShopElements.insufficientFundsMessage(player, itemValue);
                }
            }
        }

        @EventHandler
        public void onClose(InventoryCloseEvent event) {
            menus.remove(event.getInventory());
        }
    }
}

