/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.customloottable;

import com.magmaguy.elitemobs.config.EconomySettingsConfig;
import com.magmaguy.elitemobs.config.ItemSettingsConfig;
import com.magmaguy.elitemobs.economy.EconomyHandler;
import com.magmaguy.elitemobs.items.ItemLootShower;
import com.magmaguy.elitemobs.items.customloottable.CustomLootEntry;
import com.magmaguy.elitemobs.utils.MapListInterpreter;
import com.magmaguy.magmacore.util.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CurrencyCustomLootEntry
extends CustomLootEntry
implements Serializable {
    private int currencyAmount = 0;

    public CurrencyCustomLootEntry(List<CustomLootEntry> entries, int currencyAmount) {
        this.currencyAmount = currencyAmount;
        entries.add(this);
    }

    public CurrencyCustomLootEntry(List<CustomLootEntry> entries, String rawString, String configFilename) {
        block24: for (String string : rawString.split(":")) {
            String[] strings = string.split("=");
            switch (strings[0].toLowerCase(Locale.ROOT)) {
                case "currencyamount": {
                    try {
                        this.currencyAmount = Integer.parseInt(strings[1]);
                    }
                    catch (Exception ex) {
                        CurrencyCustomLootEntry.errorMessage(rawString, configFilename, "currencyAmount");
                    }
                    continue block24;
                }
                case "amount": {
                    try {
                        super.setAmount(Integer.parseInt(strings[1]));
                    }
                    catch (Exception ex) {
                        CurrencyCustomLootEntry.errorMessage(rawString, configFilename, "amount");
                    }
                    continue block24;
                }
                case "chance": {
                    try {
                        super.setChance(Double.parseDouble(strings[1]));
                    }
                    catch (Exception ex) {
                        CurrencyCustomLootEntry.errorMessage(rawString, configFilename, "chance");
                    }
                    continue block24;
                }
                case "permission": {
                    try {
                        super.setPermission(strings[1]);
                    }
                    catch (Exception ex) {
                        CurrencyCustomLootEntry.errorMessage(rawString, configFilename, "permission");
                    }
                    continue block24;
                }
                case "wave": {
                    try {
                        super.setWave(Integer.parseInt(strings[1]));
                    }
                    catch (Exception ex) {
                        CurrencyCustomLootEntry.errorMessage(rawString, configFilename, "wave");
                    }
                    continue block24;
                }
            }
        }
        if (this.currencyAmount == 0) {
            CurrencyCustomLootEntry.errorMessage(rawString, configFilename, "currencyAmount");
            return;
        }
        entries.add(this);
    }

    public CurrencyCustomLootEntry(List<CustomLootEntry> entries, Map<?, ?> configMap, String configFilename) {
        block12: for (Map.Entry<?, ?> mapEntry : configMap.entrySet()) {
            String key = (String)mapEntry.getKey();
            switch (key.toLowerCase(Locale.ROOT)) {
                case "chance": {
                    super.setChance(MapListInterpreter.parseDouble(key, mapEntry.getValue(), configFilename));
                    continue block12;
                }
                case "permission": {
                    super.setPermission(MapListInterpreter.parseString(key, mapEntry.getValue(), configFilename));
                    continue block12;
                }
                case "amount": {
                    this.setAmount(MapListInterpreter.parseInteger(key, mapEntry.getValue(), configFilename));
                    continue block12;
                }
                case "currencyamount": {
                    this.currencyAmount = MapListInterpreter.parseInteger(key, mapEntry.getValue(), configFilename);
                    continue block12;
                }
            }
            Logger.warn("Failed to read custom loot option " + key + " in " + configFilename);
        }
        entries.add(this);
    }

    @Override
    public void locationDrop(int itemTier, Player player, Location location) {
        new ItemLootShower(location, player, this.currencyAmount);
    }

    @Override
    public void directDrop(int itemTier, Player player) {
        EconomyHandler.addCurrency(player.getUniqueId(), this.currencyAmount);
        player.sendMessage(ItemSettingsConfig.getDirectDropCoinMessage().replace("$amount", "" + this.currencyAmount).replace("$currencyName", EconomySettingsConfig.getCurrencyName()));
    }

    @Override
    public ItemStack previewDrop(int itemTier, Player player) {
        ItemStack paperItem = new ItemStack(Material.PAPER);
        ItemMeta paperMeta = paperItem.getItemMeta();
        paperMeta.setDisplayName("Currency reward");
        paperMeta.setLore(List.of("Amount: " + this.currencyAmount, "Chance: " + this.getChance()));
        paperItem.setItemMeta(paperMeta);
        return paperItem;
    }

    @Generated
    public int getCurrencyAmount() {
        return this.currencyAmount;
    }
}

